(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    308369,       6438]
NotebookOptionsPosition[    307842,       6420]
NotebookOutlinePosition[    308273,       6437]
CellTagsIndexPosition[    308230,       6434]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"MatrixQ", "[", "AVl18", "]"}], ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"ToCharacterCode", "[", 
           RowBox[{"ToString", "[", "AVl18", "]"}], "]"}], ",", "62760"}], 
         "]"}], "\[Equal]", "False"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Dimensions", "[", "AVl18", "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Flatten", "[", "AVl18", "]"}], ",", "Null"}], "]"}], 
            "\[Equal]", "False"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"VectorQ", "[", "AVl19", "]"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{"AVl19", ",", "Null"}], "]"}], "\[Equal]", "False"}],
                ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"AVl19", "\[NotEqual]", 
                  RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "AVl18", "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", "AVl19", "]"}]}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", "AVl20", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"AVl20", ",", "Null"}], "]"}], "\[Equal]", 
                    "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"AVl20", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"DeleteDuplicates", "[", 
                    RowBox[{"Flatten", "[", "AVl18", "]"}], "]"}], "]"}], 
                    "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", "AVl20", "]"}], "]"}]}], ",", 
                    RowBox[{"Column", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Grafo", "[", 
                    RowBox[{"AVl18", ",", 
                    RowBox[{"pesos", "\[Rule]", "AVl19"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Buscar primero a lo ancho: \>\"", ",", " ", 
                    RowBox[{"BuscarPrimeroAncho", "[", 
                    RowBox[{
                    RowBox[{"Grafo", "[", 
                    RowBox[{"AVl18", ",", 
                    RowBox[{"pesos", "\[Rule]", "AVl19"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}], ",", 
                    RowBox[{"orden", "\[Rule]", "AVl20"}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Buscar primero a lo largo: \>\"", ",", " ", 
                    RowBox[{"BuscarPrimeroLargo", "[", 
                    RowBox[{
                    RowBox[{"Grafo", "[", 
                    RowBox[{"AVl18", ",", 
                    RowBox[{"pesos", "\[Rule]", "AVl19"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}], ",", 
                    RowBox[{"orden", "\[Rule]", "AVl20"}]}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Prim: \>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{"AVl19", ",", "NumericQ"}], "]"}], ",", 
                    RowBox[{"OPrim", "[", 
                    RowBox[{
                    RowBox[{"Grafo", "[", 
                    RowBox[{"AVl18", ",", 
                    RowBox[{"pesos", "\[Rule]", "AVl19"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}], ",",
                     "AVl20"}], "]"}], ",", "\"\<\>\""}], "]"}]}], "}"}], 
                    "]"}], ",", 
                    RowBox[{"Row", "[", 
                    RowBox[{"{", 
                    RowBox[{"\"\<Kruskal: \>\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{"AVl19", ",", "NumericQ"}], "]"}], ",", 
                    RowBox[{"OKruskal", "[", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{"AVl18", ",", 
                    RowBox[{"pesos", "\[Rule]", "AVl19"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", "True"}]}], "]"}], 
                    "]"}], ",", "\"\<\>\""}], "]"}]}], "}"}], "]"}]}], "}"}], 
                    "]"}], ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}],
                     ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
                   "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
               "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", 
           "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], "]"}], ",", "\"\<\>\""}], 
      "]"}], ",", "\"\<\>\""}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"AVl18", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "c"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"a", ",", "e"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"b", ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "e"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "d"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "f"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"e", ",", "f"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"d", ",", "f"}], "}"}]}], "}"}], ",", 
      "\"\<Aristas del grafo\>\""}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"AVl19", ",", 
      RowBox[{"{", 
       RowBox[{
       "4", ",", "2", ",", "3", ",", "5", ",", "6", ",", "1", ",", "3", ",", 
        "2", ",", "6"}], "}"}], ",", "\"\<Pesos de los lados\>\""}], "}"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"AVl20", ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "\"\<Orden de los nodos\>\""}], "}"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Clear", "[", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "]"}],
       ";", 
      RowBox[{
       RowBox[{"OPrim", "[", 
        RowBox[{"AGrafo_", ",", "AAOrden_"}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "AlgoritmoPrim", "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"AlgoritmoPrim", "[", 
            RowBox[{"AAGrafo_", ",", "OrdenLista_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"AGrafoAuxiliar3", ",", "APReglas"}], "}"}], ",", 
             RowBox[{
              RowBox[{"APReglas", "=", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"Rule", "[", 
                  RowBox[{
                   RowBox[{"ToString", "[", 
                    RowBox[{"OrdenLista", "[", 
                    RowBox[{"[", "APAi", "]"}], "]"}], "]"}], ",", "APAi"}], 
                  "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"APAi", ",", 
                   RowBox[{"VertexCount", "[", "AAGrafo", "]"}]}], "}"}]}], 
                "]"}]}], ";", 
              RowBox[{"AGrafoAuxiliar3", "=", 
               RowBox[{"Grafo", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Map", "[", 
                   RowBox[{"ToString", ",", 
                    RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", "AAGrafo", "]"}], "]"}], ",", 
                    RowBox[{"{", "2", "}"}]}], "]"}], "/.", "APReglas"}], ",", 
                 RowBox[{"pesos", "\[Rule]", 
                  RowBox[{"Table", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "AAGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"#", ",", "APAi"}], "]"}], "&"}]}], "]"}], "]"}], 
                    "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"APAi", ",", 
                    RowBox[{"EdgeList", "[", "AAGrafo", "]"}]}], "}"}]}], 
                   "]"}]}]}], "]"}]}], ";", 
              RowBox[{"Module", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"APrimn", "=", 
                   RowBox[{"VertexCount", "[", "AGrafoAuxiliar3", "]"}]}], 
                  ",", 
                  RowBox[{"APrimm", "=", 
                   RowBox[{"EdgeCount", "[", "AGrafoAuxiliar3", "]"}]}], ",", 
                  "APrimT", ",", "APrimL", ",", "APrimMP", ",", "APrimAi", 
                  ",", "APLPesos", ",", "APPesoMin", ",", "APLPosPesoMin", 
                  ",", "APPosPesoMin", ",", "APArista", ",", "APAristasArbol",
                   ",", "APPeso", ",", "APAristasS", ",", "APAristasSS", ",", 
                  "APPos1", ",", "APPos1Ext", ",", "APArbol", ",", "APNArbol",
                   ",", "APContador"}], "}"}], ",", 
                RowBox[{
                 RowBox[{"APrimT", "=", 
                  RowBox[{"Sort", "[", 
                   RowBox[{"VertexList", "[", "AGrafoAuxiliar3", "]"}], 
                   "]"}]}], ";", 
                 RowBox[{"APrimL", "=", 
                  RowBox[{"EdgeList", "[", "AGrafoAuxiliar3", "]"}]}], ";", 
                 RowBox[{"APrimMP", "=", 
                  RowBox[{
                   RowBox[{"MPGrafo", "[", 
                    RowBox[{"AGrafoAuxiliar3", ",", "APrimT"}], "]"}], "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ";", 
                 RowBox[{"APAristasS", "=", 
                  RowBox[{"{", "}"}]}], ";", 
                 RowBox[{"APAristasSS", "=", 
                  RowBox[{"{", "}"}]}], ";", 
                 RowBox[{"For", "[", 
                  RowBox[{
                   RowBox[{"APrimAi", "=", "1"}], ",", 
                   RowBox[{"APrimAi", "\[LessEqual]", "APrimn"}], ",", 
                   RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"AGrafoAuxiliar3", ",", 
                    RowBox[{
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[UndirectedEdge]", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"APAristasS", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APAristasS", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}], "}"}], ",", 
                    RowBox[{"APrimMP", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "APrimAi"}], "]"}], "]"}]}], "}"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"APAristasSS", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APAristasSS", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}], "}"}]}], 
                    "]"}]}]}]}], "]"}], ";", 
                    RowBox[{"APrimAi", "++"}]}]}], "]"}], ";", 
                 RowBox[{"APLPesos", "=", 
                  RowBox[{"{", "}"}]}], ";", 
                 RowBox[{"For", "[", 
                  RowBox[{
                   RowBox[{"APrimAi", "=", "1"}], ",", 
                   RowBox[{"APrimAi", "\[LessEqual]", 
                    RowBox[{"Length", "[", "APAristasS", "]"}]}], ",", 
                   RowBox[{
                    RowBox[{"APLPesos", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APLPesos", ",", 
                    RowBox[{"APAristasS", "[", 
                    RowBox[{"[", 
                    RowBox[{"APrimAi", ",", "2"}], "]"}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"APrimAi", "++"}]}]}], "]"}], ";", 
                 RowBox[{"APPesoMin", "=", 
                  RowBox[{"Min", "[", "APLPesos", "]"}]}], ";", 
                 RowBox[{"APLPosPesoMin", "=", 
                  RowBox[{"Flatten", "[", 
                   RowBox[{"Position", "[", 
                    RowBox[{"APLPesos", ",", "APPesoMin"}], "]"}], "]"}]}], 
                 ";", 
                 RowBox[{"APArista", "=", 
                  RowBox[{
                   RowBox[{"Sort", "[", 
                    RowBox[{"Part", "[", 
                    RowBox[{"APAristasS", ",", "APLPosPesoMin"}], "]"}], 
                    "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
                 RowBox[{"APPosPesoMin", "=", 
                  RowBox[{
                   RowBox[{"Position", "[", 
                    RowBox[{"APAristasSS", ",", "APArista"}], "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
                 RowBox[{"APAristasArbol", "=", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[UndirectedEdge]", 
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", 
                 RowBox[{"APPeso", "=", "APPesoMin"}], ";", 
                 RowBox[{"APArista", "=", 
                  RowBox[{"Last", "[", "APAristasArbol", "]"}]}], ";", 
                 RowBox[{"For", "[", 
                  RowBox[{
                   RowBox[{"APrimAi", "=", "1"}], ",", 
                   RowBox[{"APrimAi", "\[LessEqual]", "APrimn"}], ",", 
                   RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"AGrafoAuxiliar3", ",", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[UndirectedEdge]", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}]}], "]"}], ")"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}], "]"}]}], ")"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"APPos1", "=", 
                    RowBox[{"Position", "[", 
                    RowBox[{"APrimT", ",", 
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"APPos1Ext", "=", 
                    RowBox[{"APPos1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
                    RowBox[{"APAristasS", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APAristasS", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}], "}"}], ",", 
                    RowBox[{"APrimMP", "[", 
                    RowBox[{"[", 
                    RowBox[{"APPos1Ext", ",", "APrimAi"}], "]"}], "]"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"APAristasSS", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APAristasSS", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}], "}"}]}], 
                    "]"}]}]}]}], "]"}], ";", 
                    RowBox[{"APrimAi", "++"}]}]}], "]"}], ";", 
                 RowBox[{"APAristasS", "=", 
                  RowBox[{"Delete", "[", 
                   RowBox[{"APAristasS", ",", "APPosPesoMin"}], "]"}]}], ";", 
                 RowBox[{"APAristasSS", "=", 
                  RowBox[{"Delete", "[", 
                   RowBox[{"APAristasSS", ",", "APPosPesoMin"}], "]"}]}], ";", 
                 RowBox[{"APContador", "=", "1"}], ";", 
                 RowBox[{"While", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "APAristasArbol", "]"}], "<", 
                    RowBox[{"APrimn", "-", "1"}]}], ",", 
                   RowBox[{
                    RowBox[{"APLPesos", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"APrimAi", "=", "1"}], ",", 
                    RowBox[{"APrimAi", "\[LessEqual]", 
                    RowBox[{"Length", "[", "APAristasS", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"APLPesos", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APLPesos", ",", 
                    RowBox[{"APAristasS", "[", 
                    RowBox[{"[", 
                    RowBox[{"APrimAi", ",", "2"}], "]"}], "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"APrimAi", "++"}]}]}], "]"}], ";", 
                    RowBox[{"APPesoMin", "=", 
                    RowBox[{"Min", "[", "APLPesos", "]"}]}], ";", 
                    RowBox[{"APLPosPesoMin", "=", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{"Position", "[", 
                    RowBox[{"APLPesos", ",", "APPesoMin"}], "]"}], "]"}]}], 
                    ";", 
                    RowBox[{"APArista", "=", 
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"Part", "[", 
                    RowBox[{"APAristasS", ",", "APLPosPesoMin"}], "]"}], 
                    "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
                    RowBox[{"APPosPesoMin", "=", 
                    RowBox[{
                    RowBox[{"Position", "[", 
                    RowBox[{"APAristasSS", ",", "APArista"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
                    RowBox[{"APNArbol", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APAristasArbol", ",", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[UndirectedEdge]", 
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"AcyclicGraphQ", "[", "APNArbol", "]"}], ",", 
                    RowBox[{
                    RowBox[{"APAristasArbol", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APAristasArbol", ",", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[UndirectedEdge]", 
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], ";", 
                    RowBox[{"APArbol", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"APAristasArbol", ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}]}], ";", 
                    RowBox[{"APPeso", "=", 
                    RowBox[{"APPeso", "+", "APPesoMin"}]}], ";", 
                    RowBox[{"APAristasS", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"APAristasS", ",", "APPosPesoMin"}], "]"}]}], ";", 
                    RowBox[{"APAristasSS", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"APAristasSS", ",", "APPosPesoMin"}], "]"}]}], 
                    ";", 
                    RowBox[{"APContador", "++"}], ";", 
                    RowBox[{"APArista", "=", 
                    RowBox[{"Last", "[", "APAristasArbol", "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"APrimAi", "=", "1"}], ",", 
                    RowBox[{"APrimAi", "\[LessEqual]", "APrimn"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"AGrafoAuxiliar3", ",", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[UndirectedEdge]", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}]}], "]"}], ")"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}], "]"}]}], ")"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"APArbol", ",", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[UndirectedEdge]", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}]}], "]"}], 
                    "\[Equal]", "False"}], ")"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"APAristasSS", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}], "}"}]}], "]"}], 
                    "\[Equal]", "False"}], ")"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"APAristasSS", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}], ",", 
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}], 
                    "\[Equal]", "False"}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"APPos1", "=", 
                    RowBox[{"Position", "[", 
                    RowBox[{"APrimT", ",", 
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"APPos1Ext", "=", 
                    RowBox[{"APPos1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
                    RowBox[{"APAristasS", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APAristasS", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}], "}"}], ",", 
                    RowBox[{"APrimMP", "[", 
                    RowBox[{"[", 
                    RowBox[{"APPos1Ext", ",", "APrimAi"}], "]"}], "]"}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"APAristasSS", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"APAristasSS", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"APArista", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"APrimT", "[", 
                    RowBox[{"[", "APrimAi", "]"}], "]"}]}], "}"}]}], 
                    "]"}]}]}]}], "]"}], ";", 
                    RowBox[{"APrimAi", "++"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"APAristasS", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"APAristasS", ",", "APPosPesoMin"}], "]"}]}], ";", 
                    RowBox[{"APAristasSS", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"APAristasSS", ",", "APPosPesoMin"}], "]"}]}]}]}],
                     "]"}]}]}], "]"}], ";", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "AAGrafo", "]"}], ",", 
                    RowBox[{"APAi", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"APAi", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"APAi", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "AAGrafo", "]"}], ",", 
                    RowBox[{"APAi", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
                    RowBox[{"APAi", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"APAi", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"APAi", ",", 
                    RowBox[{
                    RowBox[{
                    "AristasWolframSystemToCombinatorica", "[", 
                    "APAristasArbol", "]"}], "/.", 
                    RowBox[{"Reverse", "/@", "APReglas"}]}]}], "}"}]}], "]"}],
                    ",", " ", "APPeso"}], "}"}]}]}], "]"}]}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"GrafoQ", "[", "AGrafo", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"GrafoConexoQ", "[", "AGrafo", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"!", 
                 RowBox[{"GrafoDirigidoQ", "[", "AGrafo", "]"}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"GrafoPonderadoQ", "[", "AGrafo", "]"}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"VectorQ", "[", "AAOrden", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", "AAOrden", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "AGrafo", "]"}], "]"}], 
                    "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MBooleanQ", "[", 
                    RowBox[{"Normal", "[", 
                    RowBox[{"AdjacencyMatrix", "[", "AGrafo", "]"}], "]"}], 
                    "]"}], ",", 
                    RowBox[{"AlgoritmoPrim", "[", 
                    RowBox[{"AGrafo", ",", "AAOrden"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"OKruskal", "[", "AGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "AGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoConexoQ", "[", "AGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"GrafoDirigidoQ", "[", "AGrafo", "]"}]}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"GrafoPonderadoQ", "[", "AGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"MBooleanQ", "[", 
                  RowBox[{"Normal", "[", 
                   RowBox[{"AdjacencyMatrix", "[", "AGrafo", "]"}], "]"}], 
                  "]"}], ",", 
                 RowBox[{"Module", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"AKAristasArbol", "=", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"AKPesoMinimo", "=", "0"}], ",", "AKLadosPesos", 
                    ",", "AKruskalAi", ",", "AKPesos", ",", "AKAristas", ",", 
                    "AKMinimo", ",", "AKPos1", ",", "AKPos2", ",", 
                    "AKOAristas", ",", "AKArista"}], "}"}], ",", 
                   RowBox[{
                    RowBox[{"AKLadosPesos", "=", 
                    RowBox[{"PesosAristas", "[", "AGrafo", "]"}]}], ";", 
                    RowBox[{"AKPesos", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", "AKLadosPesos", "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"AGrafo", ",", "#"}], "]"}], "\[Equal]", 
                    "False"}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"AKAristas", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", "AKLadosPesos", "]"}], ",", 
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"AGrafo", ",", "#"}], "]"}], "&"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"AKruskalAi", "=", "1"}], ";", 
                    RowBox[{"While", "[", 
                    RowBox[{
                    RowBox[{"AKruskalAi", "\[LessEqual]", 
                    RowBox[{
                    RowBox[{"VertexCount", "[", "AGrafo", "]"}], "-", "1"}]}],
                     ",", 
                    RowBox[{
                    RowBox[{"AKMinimo", "=", 
                    RowBox[{"Min", "[", "AKPesos", "]"}]}], ";", 
                    RowBox[{"AKPos1", "=", 
                    RowBox[{"Position", "[", 
                    RowBox[{"AKPesos", ",", "AKMinimo"}], "]"}]}], ";", 
                    RowBox[{"AKPos2", "=", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{"Position", "[", 
                    RowBox[{"AKPesos", ",", "AKMinimo"}], "]"}], "]"}]}], ";", 
                    RowBox[{"AKOAristas", "=", 
                    RowBox[{"Part", "[", 
                    RowBox[{"AKAristas", ",", "AKPos2"}], "]"}]}], ";", 
                    RowBox[{"AKOAristas", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"AKOAristas", ",", 
                    RowBox[{
                    RowBox[{"AcyclicGraphQ", "[", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"Append", "[", 
                    RowBox[{"AKAristasArbol", ",", "#"}], "]"}], "]"}], "]"}],
                     "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "AKOAristas", "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"AKArista", "=", 
                    RowBox[{"RandomChoice", "[", "AKOAristas", "]"}]}], ";", 
                    RowBox[{"AKPos1", "=", 
                    RowBox[{
                    RowBox[{"Position", "[", 
                    RowBox[{"AKAristas", ",", "AKArista"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
                    RowBox[{"AKAristasArbol", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"AKAristasArbol", ",", "AKArista"}], "]"}]}], ";", 
                    RowBox[{"AKPesoMinimo", "=", 
                    RowBox[{"AKPesoMinimo", "+", 
                    RowBox[{"AKLadosPesos", "[", 
                    RowBox[{"[", 
                    RowBox[{"AKPos1", ",", "2"}], "]"}], "]"}]}]}], ";", 
                    RowBox[{"AKLadosPesos", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"AKLadosPesos", ",", "AKPos1"}], "]"}]}], ";", 
                    RowBox[{"AKAristas", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"AKAristas", ",", "AKPos1"}], "]"}]}], ";", 
                    RowBox[{"AKPesos", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"AKPesos", ",", "AKPos1"}], "]"}]}], ";", 
                    RowBox[{"AKruskalAi", "++"}]}], ",", 
                    RowBox[{
                    RowBox[{"AKLadosPesos", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"AKLadosPesos", ",", "AKPos1"}], "]"}]}], ";", 
                    RowBox[{"AKAristas", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"AKAristas", ",", "AKPos1"}], "]"}]}], ";", 
                    RowBox[{"AKPesos", "=", 
                    RowBox[{"Delete", "[", 
                    RowBox[{"AKPesos", ",", "AKPos1"}], "]"}]}]}]}], 
                    "]"}]}]}], "]"}], ";", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Map", "[", 
                    RowBox[{"AristasWolframSystemToCombinatorica", ",", 
                    RowBox[{"{", "AKAristasArbol", "}"}]}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "AKPesoMinimo"}], 
                    "}"}]}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "Grafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
         RowBox[{"vertices", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"pesos", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"Grafo", "[", 
        RowBox[{"GAristas_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "GAristasNoDirigidas", ",", "GAristasDirigidas", ",", 
           "GLabelsPesos", ",", "Grafo3d", ",", "GrafoNo3d"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GAristasNoDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador4_", "\[Rule]", 
               RowBox[{"UndirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador4", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GAristasDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador5_", "\[Rule]", 
               RowBox[{"DirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador5", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GLabelsPesos", "[", 
            RowBox[{"GGrafo_", ",", "GPesos_"}], "]"}], ":=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", "GPesos", "]"}], "\[Equal]", 
              RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"GList1", "=", 
                  RowBox[{"EdgeList", "[", "GGrafo", "]"}]}], ",", 
                 RowBox[{"GList2", "=", 
                  RowBox[{"{", "}"}]}]}], "}"}], ",", 
               RowBox[{
                RowBox[{"For", "[", 
                 RowBox[{
                  RowBox[{"Gi1", "=", "1"}], ",", 
                  RowBox[{"Gi1", "\[LessEqual]", 
                   RowBox[{"Length", "[", "GList1", "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"GList2", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"GList2", ",", 
                    RowBox[{
                    RowBox[{"GList1", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}], "\[Rule]", 
                    RowBox[{"GPesos", "[", 
                    RowBox[{"[", "Gi1", "]"}], "]"}]}]}], "]"}]}], ";", 
                   RowBox[{"Gi1", "++"}]}]}], "]"}], ";", "GList2"}]}], 
              "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"Grafo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Sphere", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"Graph3D", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"GrafoNo3d", "[", "GOAristas_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl1", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"OptionValue", "[", "shape", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"VertexShapeFunction", "\[Rule]", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"White", ",", 
                    RowBox[{"EdgeForm", "[", "Black", "]"}], " ", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{"#", ",", ".1"}], "]"}], ",", "Black", ",", 
                    RowBox[{"Text", "[", 
                    RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], 
                    ")"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"ConstantArray", "[", 
                    RowBox[{"1", ",", 
                    RowBox[{"Length", "[", "GOAristas", "]"}]}], "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl1", "=", 
                    RowBox[{"GLabelsPesos", "[", 
                    RowBox[{
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}]}], "]"}], ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], ",", 
                    RowBox[{"EdgeLabels", "\[Rule]", "GVl1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}], 
                   ",", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                    RowBox[{"GAristasNoDirigidas", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}]}], "]"}]}], 
                  "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"OptionValue", "[", "vertices", "]"}], ",", 
                  "Null"}], "]"}], "\[Equal]", "False"}], "&&", 
               RowBox[{
                RowBox[{"MemberQ", "[", 
                 RowBox[{
                  RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "Null"}], 
                 "]"}], "\[Equal]", "False"}]}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"MatrixQ", "[", "GAristas", "]"}], "||", 
                   RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ")"}], "&&", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"Flatten", "[", "GAristas", "]"}], ",", "Null"}], 
                   "]"}], "\[Equal]", "False"}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}]}], "||", 
                   RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "&&", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}], 
                    "\[NotEqual]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"MatrixQ", "[", "GAristas", "]"}], "&&", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "GAristas", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&&", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "GAristas", "]"}], "]"}], ",", 
                    "62760"}], "]"}], "\[Equal]", "False"}]}], ")"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                    RowBox[{"Grafo3d", "[", "GAristas", "]"}], ",", 
                    RowBox[{"GrafoNo3d", "[", "GAristas", "]"}]}], "]"}]}], 
                   "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"Options", "[", "BuscarPrimeroAncho", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"animacion", "\[Rule]", "False"}], ",", 
         RowBox[{"orden", "\[Rule]", 
          RowBox[{"{", "}"}]}]}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"BuscarPrimeroAncho", "[", 
        RowBox[{"AGrafo_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "AOPreOrden", "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"AOPreOrden", "[", 
            RowBox[{"AAGrafo_", ",", "ARaiz_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "OPrefi", ",", "AAList31", ",", "AList29", ",", "AList30", ",", 
               "AAristas", ",", "AAGrafoAuxiliar1"}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"OPrefi", "[", 
                RowBox[{"AAAGrafo_", ",", "AARaiz_"}], "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"AAAList29", "=", 
                    RowBox[{"{", "}"}]}], ",", "AAAGrafoAuxiliar1"}], "}"}], 
                 ",", 
                 RowBox[{
                  RowBox[{"AAAGrafoAuxiliar1", "=", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "AAAGrafo", "]"}], ",", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"EdgeList", "[", "AAAGrafo", "]"}], "]"}]}], 
                    "]"}]}], ";", 
                  RowBox[{"AAAList29", "=", 
                   RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                    RowBox[{
                    RowBox[{"Reap", "[", 
                    RowBox[{"BreadthFirstScan", "[", 
                    RowBox[{"AAAGrafoAuxiliar1", ",", "AARaiz", ",", 
                    RowBox[{"\"\<FrontierEdge\>\"", "\[Rule]", "Sow"}]}], 
                    "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
                  "AAAList29"}]}], "]"}]}], ";", 
              RowBox[{"AList29", "=", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ToString", "[", 
                   RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                  "\[Equal]", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"{", "}"}], "]"}]}], ",", 
                 RowBox[{"VertexList", "[", "AAGrafo", "]"}], ",", 
                 RowBox[{"OptionValue", "[", "orden", "]"}]}], "]"}]}], ";", 
              RowBox[{"AAristas", "=", 
               RowBox[{"{", "}"}]}], ";", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"Ai24", "=", "1"}], ",", 
                RowBox[{"Ai24", "\[LessEqual]", 
                 RowBox[{"Length", "[", "AList29", "]"}]}], ",", 
                RowBox[{
                 RowBox[{"AAristas", "=", 
                  RowBox[{"Append", "[", 
                   RowBox[{"AAristas", ",", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "AAGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"AList29", "[", 
                    RowBox[{"[", "Ai24", "]"}], "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"AList29", "[", 
                    RowBox[{"[", "Ai24", "]"}], "]"}]}]}], "&"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"Ai24", "++"}]}]}], "]"}], ";", 
              RowBox[{"AAristas", "=", 
               RowBox[{"DeleteDuplicates", "[", 
                RowBox[{"Flatten", "[", "AAristas", "]"}], "]"}]}], ";", 
              RowBox[{"AList30", "=", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"Rule", "[", 
                  RowBox[{
                   RowBox[{"ToString", "[", 
                    RowBox[{"AList29", "[", 
                    RowBox[{"[", "Ai24", "]"}], "]"}], "]"}], ",", "Ai24"}], 
                  "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Ai24", ",", 
                   RowBox[{"VertexCount", "[", "AAGrafo", "]"}]}], "}"}]}], 
                "]"}]}], ";", 
              RowBox[{"AAGrafoAuxiliar1", "=", 
               RowBox[{"Grafo", "[", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Ai27", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ">", 
                    RowBox[{"Ai27", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"Reverse", "[", "Ai27", "]"}], ",", "Ai27"}], 
                   "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"Ai27", ",", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Ai24", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Ai24", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Ai24", ",", 
                    RowBox[{
                    "AristasWolframSystemToCombinatorica", "[", "AAristas", 
                    "]"}]}], "}"}]}], "]"}], "/.", "AList30"}]}], "}"}]}], 
                 "]"}], "]"}]}], ";", 
              RowBox[{"AAList31", "=", 
               RowBox[{
                RowBox[{"OPrefi", "[", 
                 RowBox[{"AAGrafoAuxiliar1", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Select", "[", 
                    RowBox[{"AList30", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", "ARaiz", "]"}]}], "&"}]}], "]"}],
                     "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "/.", 
                RowBox[{"Reverse", "/@", "AList30"}]}]}], ";", 
              RowBox[{"AAList31", "=", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "AAGrafo", "]"}], ",", 
                    "Ai24"}], "]"}], ",", "Ai24", ",", 
                   RowBox[{"ToExpression", "[", "Ai24", "]"}]}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Ai24", ",", "AAList31"}], "}"}]}], "]"}]}], ";", 
              "AAList31"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"BooleanQ", "[", 
             RowBox[{"OptionValue", "[", "animacion", "]"}], "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"VectorQ", "[", 
               RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"GrafoQ", "[", "AGrafo", "]"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"!", 
                   RowBox[{"GrafoDirigidoQ", "[", "AGrafo", "]"}]}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"GrafoConexoQ", "[", "AGrafo", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "AGrafo", "]"}], "]"}], 
                    "]"}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"AList31", "=", 
                    RowBox[{"AOPreOrden", "[", 
                    RowBox[{"AGrafo", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"VertexList", "[", "AGrafo", "]"}], "]"}], ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}]}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "animacion", "]"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", "AList31", "]"}], ";", 
                    RowBox[{"AnimarGrafo", "[", 
                    RowBox[{"AGrafo", ",", "AList31"}], "]"}]}], ",", 
                    "AList31"}], "]"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"GrafoCQ", "[", "AGrafo", "]"}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"!", 
                    RowBox[{"GrafoDirigidoQ", "[", "AGrafo", "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoConexoQ", "[", "AGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"AGrafoAuxiliar1", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{"Edges", "[", "AGrafo", "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "AGrafoAuxiliar1", "]"}], 
                    "]"}], "]"}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"AList31", "=", 
                    RowBox[{"AOPreOrden", "[", 
                    RowBox[{"AGrafoAuxiliar1", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"VertexList", "[", "AGrafoAuxiliar1", "]"}], 
                    "]"}], ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}]}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "animacion", "]"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", "AList31", "]"}], ";", 
                    RowBox[{"AnimarGrafoWithCombinatorica", "[", 
                    RowBox[{"AGrafo", ",", "AList31"}], "]"}]}], ",", 
                    "AList31"}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], 
                 "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{
       "AristasWolframSystemToCombinatorica", "[", "GAristasGrafo_", "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GGrafoAuxiliar1", "=", 
           RowBox[{"System`Graph", "[", "GAristasGrafo", "]"}]}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GraphQ", "[", "GGrafoAuxiliar1", "]"}], ",", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GAristasGrafo", ",", 
              RowBox[{"Gicontador1_", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Gicontador1", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador1", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}]}], "]"}], "]"}]}],
           "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GraphQ", "[", "GGrafo", "]"}], ",", "True", ",", "False"}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoCQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumericQ", "[", 
          RowBox[{"V", "[", "GGrafo", "]"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"V", "[", "GGrafo", "]"}], "\[Equal]", "0"}], ",", 
           "False", ",", "True"}], "]"}], ",", "False"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoDirigidoQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"UndirectedGraphQ", "[", "GGrafo", "]"}], ",", "False", 
           ",", "True"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"UndirectedQ", "[", "GGrafo", "]"}], ",", "False", ",", 
             "True"}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"GrafoConexoQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ConnectedGraphQ", "[", "GGrafo", "]"}], ",", "True", ",", 
           "False"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ConnectedQ", "[", "GGrafo", "]"}], ",", "True", ",", 
             "False"}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "BuscarPrimeroLargo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"animacion", "\[Rule]", "False"}], ",", 
         RowBox[{"orden", "\[Rule]", 
          RowBox[{"{", "}"}]}]}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"BuscarPrimeroLargo", "[", 
        RowBox[{"AGrafo_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "AOOPreOrden", "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"AOOPreOrden", "[", 
            RowBox[{"AAGrafo_", ",", "ARaiz_"}], "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "OOPrefi", ",", "AAList32", ",", "AList33", ",", "AList34", ",",
                "AAristas", ",", "AAGrafoAuxiliar2"}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{"OOPrefi", "[", 
                RowBox[{"AAAGrafo_", ",", "AARaiz_"}], "]"}], ":=", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"AAAList32", "=", 
                    RowBox[{"{", "}"}]}], ",", "AAAGrafoAuxiliar2"}], "}"}], 
                 ",", 
                 RowBox[{
                  RowBox[{"AAAGrafoAuxiliar2", "=", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "AAAGrafo", "]"}], ",", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"EdgeList", "[", "AAAGrafo", "]"}], "]"}]}], 
                    "]"}]}], ";", 
                  RowBox[{"AAAList32", "=", 
                   RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                    RowBox[{
                    RowBox[{"Reap", "[", 
                    RowBox[{"DepthFirstScan", "[", 
                    RowBox[{"AAAGrafoAuxiliar2", ",", "AARaiz", ",", 
                    RowBox[{"\"\<FrontierEdge\>\"", "\[Rule]", "Sow"}]}], 
                    "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
                  "AAAList32"}]}], "]"}]}], ";", 
              RowBox[{"AList33", "=", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ToString", "[", 
                   RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                  "\[Equal]", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"{", "}"}], "]"}]}], ",", 
                 RowBox[{"VertexList", "[", "AAGrafo", "]"}], ",", 
                 RowBox[{"OptionValue", "[", "orden", "]"}]}], "]"}]}], ";", 
              RowBox[{"AAristas", "=", 
               RowBox[{"{", "}"}]}], ";", 
              RowBox[{"For", "[", 
               RowBox[{
                RowBox[{"Ai25", "=", "1"}], ",", 
                RowBox[{"Ai25", "\[LessEqual]", 
                 RowBox[{"Length", "[", "AList33", "]"}]}], ",", 
                RowBox[{
                 RowBox[{"AAristas", "=", 
                  RowBox[{"Append", "[", 
                   RowBox[{"AAristas", ",", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "AAGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"AList33", "[", 
                    RowBox[{"[", "Ai25", "]"}], "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"AList33", "[", 
                    RowBox[{"[", "Ai25", "]"}], "]"}]}]}], "&"}]}], "]"}]}], 
                   "]"}]}], ";", 
                 RowBox[{"Ai25", "++"}]}]}], "]"}], ";", 
              RowBox[{"AAristas", "=", 
               RowBox[{"DeleteDuplicates", "[", 
                RowBox[{"Flatten", "[", "AAristas", "]"}], "]"}]}], ";", 
              RowBox[{"AList34", "=", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"Rule", "[", 
                  RowBox[{
                   RowBox[{"ToString", "[", 
                    RowBox[{"AList33", "[", 
                    RowBox[{"[", "Ai25", "]"}], "]"}], "]"}], ",", "Ai25"}], 
                  "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Ai25", ",", 
                   RowBox[{"VertexCount", "[", "AAGrafo", "]"}]}], "}"}]}], 
                "]"}]}], ";", 
              RowBox[{"AAGrafoAuxiliar2", "=", 
               RowBox[{"Grafo", "[", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Ai26", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ">", 
                    RowBox[{"Ai26", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"Reverse", "[", "Ai26", "]"}], ",", "Ai26"}], 
                   "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"Ai26", ",", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Ai25", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Ai25", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Ai25", ",", 
                    RowBox[{
                    "AristasWolframSystemToCombinatorica", "[", "AAristas", 
                    "]"}]}], "}"}]}], "]"}], "/.", "AList34"}]}], "}"}]}], 
                 "]"}], "]"}]}], ";", 
              RowBox[{"AAList32", "=", 
               RowBox[{
                RowBox[{"OOPrefi", "[", 
                 RowBox[{"AAGrafoAuxiliar2", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Select", "[", 
                    RowBox[{"AList34", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", "ARaiz", "]"}]}], "&"}]}], "]"}],
                     "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "/.", 
                RowBox[{"Reverse", "/@", "AList34"}]}]}], ";", 
              RowBox[{"AAList32", "=", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"VertexList", "[", "AAGrafo", "]"}], ",", 
                    "Ai25"}], "]"}], ",", "Ai25", ",", 
                   RowBox[{"ToExpression", "[", "Ai25", "]"}]}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Ai25", ",", "AAList32"}], "}"}]}], "]"}]}], ";", 
              "AAList32"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"BooleanQ", "[", 
             RowBox[{"OptionValue", "[", "animacion", "]"}], "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"VectorQ", "[", 
               RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"GrafoQ", "[", "AGrafo", "]"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"!", 
                   RowBox[{"GrafoDirigidoQ", "[", "AGrafo", "]"}]}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"GrafoConexoQ", "[", "AGrafo", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "AGrafo", "]"}], "]"}], 
                    "]"}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"AList32", "=", 
                    RowBox[{"AOOPreOrden", "[", 
                    RowBox[{"AGrafo", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"VertexList", "[", "AGrafo", "]"}], "]"}], ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}]}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "animacion", "]"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", "AList32", "]"}], ";", 
                    RowBox[{"AnimarGrafo", "[", 
                    RowBox[{"AGrafo", ",", "AList32"}], "]"}]}], ",", 
                    "AList32"}], "]"}]}]}], "]"}]}], "]"}]}], "]"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"GrafoCQ", "[", "AGrafo", "]"}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"!", 
                    RowBox[{"GrafoDirigidoQ", "[", "AGrafo", "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoConexoQ", "[", "AGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"AGrafoAuxiliar2", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{"Edges", "[", "AGrafo", "]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "AGrafoAuxiliar2", "]"}], 
                    "]"}], "]"}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"AList32", "=", 
                    RowBox[{"AOOPreOrden", "[", 
                    RowBox[{"AGrafoAuxiliar2", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"VertexList", "[", "AGrafoAuxiliar2", "]"}], 
                    "]"}], ",", 
                    RowBox[{"First", "[", 
                    RowBox[{"OptionValue", "[", "orden", "]"}], "]"}]}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "animacion", "]"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", "AList32", "]"}], ";", 
                    RowBox[{"AnimarGrafoWithCombinatorica", "[", 
                    RowBox[{"AGrafo", ",", "AList32"}], "]"}]}], ",", 
                    "AList32"}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], 
                 "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"AnimarGrafo", "[", 
        RowBox[{"GGrafo_", ",", "GLista_"}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatrixQ", "[", "GLista", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Flatten", "[", "GLista", "]"}], ",", "Null"}], "]"}], 
            "\[Equal]", "False"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{
                RowBox[{"ToCharacterCode", "[", 
                 RowBox[{"ToString", "[", "GLista", "]"}], "]"}], ",", 
                "62760"}], "]"}], "\[Equal]", "False"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Dimensions", "[", "GLista", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
                   RowBox[{
                    RowBox[{"GGrafoAuxiliar12", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}]}]}], "]"}]}], 
                    ";", 
                    RowBox[{"GList6", "=", 
                    RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
                    RowBox[{"GLista", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"HighlightGraph", "[", 
                    RowBox[{"GGrafoAuxiliar12", ",", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"GList6", ",", 
                    RowBox[{"Gicontador10_", "/;", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi14", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi14", ",", "Gi13"}], "}"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"Position", "[", 
                    RowBox[{"GList6", ",", "Gicontador10"}], "]"}], "]"}], 
                    "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{
                    "GraphHighlightStyle", "\[Rule]", "\"\<Thick\>\""}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Gi13", ",", "1", ",", "\"\<Aristas\>\""}], "}"}],
                     ",", "1", ",", 
                    RowBox[{"Length", "[", "GList6", "]"}], ",", "1"}], 
                    "}"}]}], "]"}], "]"}]}], ",", 
                   RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"UndirectedGraphQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"GList6", "=", 
                    RowBox[{
                    "AristasCombinatoricaToWolframSystem", "[", "GLista", 
                    "]"}]}], ",", 
                    RowBox[{"GList6", "=", 
                    RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
                    RowBox[{"GLista", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"GGrafoAuxiliar12", "=", 
                    RowBox[{"System`Graph", "[", "GGrafo", "]"}]}], ";", 
                    RowBox[{"Print", "[", 
                    RowBox[{"Manipulate", "[", 
                    RowBox[{
                    RowBox[{"HighlightGraph", "[", 
                    RowBox[{"GGrafoAuxiliar12", ",", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"GList6", ",", 
                    RowBox[{"Gicontador10_", "/;", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi14", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi14", ",", "Gi13"}], "}"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"Position", "[", 
                    RowBox[{"GList6", ",", "Gicontador10"}], "]"}], "]"}], 
                    "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"VertexLabels", "\[Rule]", "\"\<Name\>\""}], ",", 
                    RowBox[{"ImagePadding", "\[Rule]", "10"}], ",", 
                    RowBox[{
                    "GraphHighlightStyle", "\[Rule]", "\"\<Thick\>\""}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Gi13", ",", "1", ",", "\"\<Aristas\>\""}], "}"}],
                     ",", "1", ",", 
                    RowBox[{"Length", "[", "GList6", "]"}], ",", "1"}], 
                    "}"}]}], "]"}], "]"}]}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
                   RowBox[{"AnimateGraph", "[", 
                    RowBox[{"GGrafo", ",", "GLista", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"HighlightedEdgeColors", "\[Rule]", "Green"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"AnimarGrafoWithCombinatorica", "[", 
        RowBox[{"GGrafo_", ",", "GLista_"}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatrixQ", "[", "GLista", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Flatten", "[", "GLista", "]"}], ",", "Null"}], "]"}], 
            "\[Equal]", "False"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{
                RowBox[{"ToCharacterCode", "[", 
                 RowBox[{"ToString", "[", "GLista", "]"}], "]"}], ",", 
                "62760"}], "]"}], "\[Equal]", "False"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"Dimensions", "[", "GLista", "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
                 RowBox[{
                  RowBox[{"Clear", "[", "Global`G", "]"}], ";", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GraphToCombinatorica", "[", "GGrafo", "]"}], 
                    "}"}], ",", "Null"}], "]"}], "\[Equal]", "False"}], ",", 
                    RowBox[{
                    RowBox[{"GraphToCombinatorica", "[", "GGrafo", "]"}], ";", 
                    RowBox[{"AnimateGraph", "[", 
                    RowBox[{"Global`G", ",", "GLista", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}], ",", 
                    RowBox[{"HighlightedEdgeColors", "\[Rule]", "Green"}]}], 
                    "]"}]}]}], "]"}]}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
                   RowBox[{"AnimateGraph", "[", 
                    RowBox[{"GGrafo", ",", "GLista", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}], ",", 
                    RowBox[{"HighlightedEdgeColors", "\[Rule]", "Green"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "AristasCombinatoricaToWolframSystem", "]"}], 
       "=", 
       RowBox[{"{", 
        RowBox[{"dirigido", "\[Rule]", "False"}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
        RowBox[{"GAristasGrafo_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GAristasNoDirigidas", ",", "GAristasDirigidas"}], "}"}], 
         ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GAristasNoDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador2_", "\[Rule]", 
               RowBox[{"UndirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador2", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador2", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{
           RowBox[{"GAristasDirigidas", "[", "GOAritas_", "]"}], ":=", 
           RowBox[{"Quiet", "[", 
            RowBox[{"Cases", "[", 
             RowBox[{"GOAritas", ",", 
              RowBox[{"Gicontador3_", "\[Rule]", 
               RowBox[{"DirectedEdge", "[", 
                RowBox[{
                 RowBox[{"Gicontador3", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"Gicontador3", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], "]"}], "]"}]}],
           ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"MatrixQ", "[", "GAristasGrafo", "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"MemberQ", "[", 
                RowBox[{
                 RowBox[{"ToCharacterCode", "[", 
                  RowBox[{"ToString", "[", "GAristasGrafo", "]"}], "]"}], ",",
                  "62760"}], "]"}], "\[Equal]", "False"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"MemberQ", "[", 
                  RowBox[{
                   RowBox[{"Flatten", "[", "GAristasGrafo", "]"}], ",", 
                   "Null"}], "]"}], "\[Equal]", "False"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"Dimensions", "[", "GAristasGrafo", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "dirigido", "]"}], ",", 
                    RowBox[{"GAristasDirigidas", "[", "GAristasGrafo", "]"}], 
                    ",", 
                    RowBox[{
                    "GAristasNoDirigidas", "[", "GAristasGrafo", "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "GraphToCombinatorica", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"mostrarpesos", "\[Rule]", "False"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"GraphToCombinatorica", "[", 
        RowBox[{"GGrafo_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "GrafoCOO", "}"}], ",", 
         RowBox[{
          RowBox[{"Clear", "[", "Global`G", "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"GrafoCOO", "[", "GOGrafo_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"GVl3", "=", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"AristasMixtasQ", "[", "GOGrafo", "]"}], ",", 
                  RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
                   RowBox[{"EdgeList", "[", "GOGrafo", "]"}], "]"}], ",", 
                  RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                   RowBox[{"EdgeList", "[", "GOGrafo", "]"}], "]"}]}], 
                 "]"}]}], ",", "GVl4", ",", "GGrafoAuxiliar11"}], "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedGraphQ", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl4", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl4", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl4", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"GOGrafo", ",", "#"}], "]"}], "\[Equal]", 
                    "False"}], "&"}]}], "]"}]}], ";", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{"GVl4", ",", "NumericQ"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVl3", "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", "0"}]}], "]"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl4"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"V", "[", "Global`G", "]"}], "\[Equal]", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVl3", "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", "0"}]}], "]"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl4"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}], "-", 
                    RowBox[{"V", "[", "Global`G", "]"}]}]}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl4"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}], ",", 
                 RowBox[{
                  RowBox[{"GrafoC", "[", 
                   RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVl3", "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", "0"}]}], "]"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                   "]"}], ";", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"V", "[", "Global`G", "]"}], "\[Equal]", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVl3", "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", "0"}]}], "]"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}], "-", 
                    RowBox[{"V", "[", "Global`G", "]"}]}]}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}]}], "]"}]}]}], "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl4", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GGrafoAuxiliar11", "=", 
                   RowBox[{"System`Graph", "[", 
                    RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}], "]"}]}],
                   ";", 
                  RowBox[{"GVl4", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl4", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"GGrafoAuxiliar11", ",", "#"}], "]"}], "\[Equal]",
                     "False"}], "&"}]}], "]"}]}], ";", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"VectorQ", "[", 
                    RowBox[{"GVl4", ",", "NumericQ"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVl3", "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", "0"}]}], "]"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl4"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"V", "[", "Global`G", "]"}], "\[Equal]", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVl3", "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", "0"}]}], "]"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl4"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}], "-", 
                    RowBox[{"V", "[", "Global`G", "]"}]}]}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl4"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}], ",", 
                 RowBox[{
                  RowBox[{"GrafoC", "[", 
                   RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVl3", "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", "0"}]}], "]"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                   "]"}], ";", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"V", "[", "Global`G", "]"}], "\[Equal]", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GVl3", "\[Equal]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}]}], ",", 
                    RowBox[{"vertices", "\[Rule]", "0"}]}], "]"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"GrafoC", "[", 
                    RowBox[{"GVl3", ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", " ", 
                    RowBox[{
                    RowBox[{"VertexCount", "[", "GOGrafo", "]"}], "-", 
                    RowBox[{"V", "[", "Global`G", "]"}]}]}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"BooleanQ", "[", 
             RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"VectorQ", "[", 
                 RowBox[{
                  RowBox[{"VertexList", "[", "GGrafo", "]"}], ",", 
                  "IntegerQ"}], "]"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}], "]"}], 
                   "\[Equal]", 
                   RowBox[{"Table", "[", 
                    RowBox[{"Gi3", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi3", ",", "1", ",", 
                    RowBox[{"VertexCount", "[", "GGrafo", "]"}]}], "}"}]}], 
                    "]"}]}], ",", 
                  RowBox[{"GrafoCOO", "[", "GGrafo", "]"}]}], "]"}]}], 
               "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "GrafoC", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
         RowBox[{"vertices", "\[Rule]", "0"}], ",", 
         RowBox[{"pesos", "\[Rule]", 
          RowBox[{"{", "}"}]}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}]}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"GrafoC", "[", 
        RowBox[{"GAristas_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "\[Equal]", 
           RowBox[{"ToString", "[", 
            RowBox[{"{", "}"}], "]"}]}], "||", 
          RowBox[{"VectorQ", "[", 
           RowBox[{
            RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "NumericQ"}], 
           "]"}]}], ",", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", "GrafoCO", "}"}], ",", 
           RowBox[{
            RowBox[{"Clear", "[", "Global`G", "]"}], ";", 
            RowBox[{
             RowBox[{"GrafoCO", "[", "GOAristas_", "]"}], ":=", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", "}"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"OptionValue", "[", "dirigido", "]"}], "&&", 
                    RowBox[{"GOAristas", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromOrderedPairs", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeLabels", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"GetEdgeWeights", "[", "Global`G", "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}]}], "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromOrderedPairs", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"AddVertices", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", "2"}],
                     "}"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeLabels", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"GetEdgeWeights", "[", "Global`G", "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}]}], "]"}]}]}],
                     "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromOrderedPairs", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeWeights", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeLabels", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"GetEdgeWeights", "[", "Global`G", "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}]}], "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromOrderedPairs", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeWeights", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"AddVertices", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", "2"}],
                     "}"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeLabels", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"GetEdgeWeights", "[", "Global`G", "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}]}], "]"}]}]}],
                     "]"}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromUnorderedPairs", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeLabels", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"GetEdgeWeights", "[", "Global`G", "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}]}], "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GOAristas", "!=", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"FromUnorderedPairs", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"EmptyGraph", "[", 
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GOAristas", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"AddVertices", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", "2"}],
                     "}"}]}], "]"}]}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeLabels", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"GetEdgeWeights", "[", "Global`G", "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}]}], "]"}]}]}],
                     "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromUnorderedPairs", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeWeights", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeLabels", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"GetEdgeWeights", "[", "Global`G", "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}]}], "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GOAristas", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"FromUnorderedPairs", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"EmptyGraph", "[", 
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeWeights", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GOAristas", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"AddVertices", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", "2"}],
                     "}"}]}], "]"}]}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeLabels", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"GetEdgeWeights", "[", "Global`G", "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}], ",", 
                    RowBox[{"EdgeLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"EdgeLabelColor", "\[Rule]", "Red"}]}], "]"}]}]}],
                     "]"}]}], "]"}]}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"OptionValue", "[", "dirigido", "]"}], "&&", 
                    RowBox[{"GOAristas", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}]}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromOrderedPairs", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromOrderedPairs", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"AddVertices", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", "2"}],
                     "}"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromOrderedPairs", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeWeights", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromOrderedPairs", "[", "GOAristas", "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeWeights", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"AddVertices", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", "2"}],
                     "}"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromUnorderedPairs", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GOAristas", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"FromUnorderedPairs", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"EmptyGraph", "[", 
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GOAristas", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"AddVertices", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", "2"}],
                     "}"}]}], "]"}]}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}]}]}], 
                    "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "\[Equal]",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"FromUnorderedPairs", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeWeights", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetGraphOptions", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GOAristas", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"FromUnorderedPairs", "[", "GOAristas", "]"}], 
                    ",", 
                    RowBox[{"EmptyGraph", "[", 
                    RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"VertexColor", "\[Rule]", "Blue"}], ",", 
                    RowBox[{"EdgeColor", "\[Rule]", "Black"}]}], "]"}]}], ";", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"SetEdgeWeights", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}]}], "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GOAristas", "\[NotEqual]", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"Global`G", "=", 
                    RowBox[{"AddVertices", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"RandomReal", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Min", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}], ",", 
                    RowBox[{"Max", "[", 
                    RowBox[{"Vertices", "[", "Global`G", "]"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "vertices", "]"}], ",", "2"}],
                     "}"}]}], "]"}]}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"ShowGraph", "[", 
                    RowBox[{"Global`G", ",", 
                    RowBox[{"VertexLabel", "\[Rule]", "True"}], ",", 
                    RowBox[{"PlotRange", "\[Rule]", "0.1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"BooleanQ", "[", 
                RowBox[{"OptionValue", "[", "dirigido", "]"}], "]"}], "&&", 
               RowBox[{"IntegerQ", "[", 
                RowBox[{"OptionValue", "[", "vertices", "]"}], "]"}], "&&", 
               RowBox[{"VectorQ", "[", 
                RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], "&&", 
               RowBox[{"BooleanQ", "[", 
                RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}]}], 
              ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"OptionValue", "[", "vertices", "]"}], 
                  "\[GreaterEqual]", "0"}], "&&", 
                 RowBox[{
                  RowBox[{"MemberQ", "[", 
                   RowBox[{
                    RowBox[{"OptionValue", "[", "pesos", "]"}], ",", "Null"}],
                    "]"}], "\[Equal]", "False"}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"MatrixQ", "[", "GAristas", "]"}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ")"}], "&&", 
                   RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", "GAristas", "]"}], ",", "Null"}], 
                    "]"}], "\[Equal]", "False"}]}], ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"Length", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}]}], "||", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"OptionValue", "[", "pesos", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", "GAristas", "]"}], "\[Equal]", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"{", "}"}], "]"}]}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"MatrixQ", "[", 
                    RowBox[{"GAristas", ",", "IntegerQ"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Dimensions", "[", "GAristas", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "2"}], "&&", 
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"ToCharacterCode", "[", 
                    RowBox[{"ToString", "[", "GAristas", "]"}], "]"}], ",", 
                    "62760"}], "]"}], "\[Equal]", "False"}]}], ")"}]}], ",", 
                    RowBox[{"GrafoCO", "[", "GAristas", "]"}]}], "]"}]}], 
                   "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], 
      ";", 
      RowBox[{
       RowBox[{"GrafoPonderadoQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"PesosAristas", "[", "GGrafo", "]"}], "}"}], ",", 
              "Null"}], "]"}]}], ",", "True", ",", "False"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"!", 
              RowBox[{"MemberQ", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"PesosAristas", "[", "GGrafo", "]"}], "}"}], ",", 
                "Null"}], "]"}]}], ",", "True", ",", "False"}], "]"}]}], 
          "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "MPGrafo", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{"table", "\[Rule]", "False"}], "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"MPGrafo", "[", 
        RowBox[{"GGrafo_", ",", "GNodos_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GGrafoAuxiliar7", ",", "GVl13"}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"VectorQ", "[", "GNodos", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MemberQ", "[", 
               RowBox[{"GNodos", ",", "Null"}], "]"}], "\[Equal]", "False"}], 
             ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"GNodos", "\[NotEqual]", 
                RowBox[{"{", "}"}]}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"BooleanQ", "[", 
                  RowBox[{"OptionValue", "[", "table", "]"}], "]"}], ",", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"PesosAristas", "[", "GGrafo", "]"}], "}"}], ",", 
                    "Null"}], "]"}], "\[Equal]", "False"}], ",", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafo", "]"}], "]"}], 
                    "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"AristasCombinatoricaToWolframSystem", "[", 
                    RowBox[{
                    RowBox[{"AristasMixtasWolframSystemToCombinatorica", "[", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}]}], "]"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"GVl13", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GGrafo", "]"}], ",", "1"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"GGrafoAuxiliar7", ",", "#"}], "]"}], "\[Equal]", 
                    "False"}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar7", "]"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", "GVl13"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"GVl13", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GGrafo", "]"}], ",", "1"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeQ", "[", 
                    RowBox[{"GGrafo", ",", "#"}], "]"}], "\[Equal]", 
                    "False"}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"System`Graph", "[", 
                    RowBox[{"GNodos", ",", 
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"System`EdgeWeight", "\[Rule]", "GVl13"}]}], 
                    "]"}]}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{"MatrixForm", "[", 
                    RowBox[{
                    "WeightedAdjacencyMatrix", "[", "GGrafoAuxiliar7", "]"}], 
                    "]"}], ",", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"Normal", "@", 
                    RowBox[{
                    "WeightedAdjacencyMatrix", "[", "GGrafoAuxiliar7", 
                    "]"}]}], ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}], "]"}]}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
                    RowBox[{
                    RowBox[{"GVl13", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GGrafo", "]"}], ",", "1"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "#", "]"}], "\[Equal]", "False"}], 
                    "&"}]}], "]"}]}], ";", 
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"CombinatoricaToGraph", "[", "GGrafo", "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sort", "[", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}], 
                    "]"}], "\[Equal]", 
                    RowBox[{"Sort", "[", "GNodos", "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"GGrafoAuxiliar7", "=", 
                    RowBox[{"Grafo", "[", 
                    RowBox[{
                    RowBox[{"Edges", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"vertices", "\[Rule]", "GNodos"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", 
                    RowBox[{"!", 
                    RowBox[{"UndirectedQ", "[", "GGrafo", "]"}]}]}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl13"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"OptionValue", "[", "table", "]"}]}], ",", 
                    RowBox[{"MatrixForm", "[", 
                    RowBox[{
                    "WeightedAdjacencyMatrix", "[", "GGrafoAuxiliar7", "]"}], 
                    "]"}], ",", 
                    RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"Normal", "@", 
                    RowBox[{
                    "WeightedAdjacencyMatrix", "[", "GGrafoAuxiliar7", 
                    "]"}]}], ",", 
                    RowBox[{"TableHeadings", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"#", ",", "Black"}], "]"}], "&"}], "/@", 
                    RowBox[{"VertexList", "[", "GGrafoAuxiliar7", "]"}]}]}], 
                    "}"}]}], ",", 
                    RowBox[{"TableAlignments", "\[Rule]", "Center"}]}], 
                    "]"}]}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"Options", "[", "CombinatoricaToGraph", "]"}], "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
         RowBox[{"mostrarpesos", "\[Rule]", "False"}], ",", 
         RowBox[{"shape", "\[Rule]", "False"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CombinatoricaToGraph", "[", 
        RowBox[{"GGrafo_", ",", 
         RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GrafoO3d", ",", "GrafoONo3d"}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"GrafoO3d", "[", "GOGrafo_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl2", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "True"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{
           RowBox[{"GrafoONo3d", "[", "GOGrafo_", "]"}], ":=", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "GVl2", "}"}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"UndirectedQ", "[", "GOGrafo", "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "False"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}], ",", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"ListQ", "[", 
                  RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"PesosAristas", "[", "GOGrafo", "]"}], ",", "1"}],
                     "]"}]}], ";", 
                  RowBox[{"GVl2", "=", 
                   RowBox[{"Select", "[", 
                    RowBox[{"GVl2", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VectorQ", "[", "#", "]"}], "\[Equal]", "False"}],
                     "&"}]}], "]"}]}], ";", 
                  RowBox[{"Grafo", "[", 
                   RowBox[{
                    RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                    RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                    RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                    ",", 
                    RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                    RowBox[{"pesos", "\[Rule]", "GVl2"}], ",", 
                    RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                    RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                 ",", 
                 RowBox[{"Grafo", "[", 
                  RowBox[{
                   RowBox[{"Edges", "[", "GOGrafo", "]"}], ",", 
                   RowBox[{"dirigido", "\[Rule]", "True"}], ",", 
                   RowBox[{"vertices", "\[Rule]", 
                    RowBox[{"Table", "[", 
                    RowBox[{"Gi4", ",", 
                    RowBox[{"{", 
                    RowBox[{"Gi4", ",", "1", ",", 
                    RowBox[{"V", "[", "GOGrafo", "]"}]}], "}"}]}], "]"}]}], 
                   ",", 
                   RowBox[{"dimensions3d", "\[Rule]", "False"}], ",", 
                   RowBox[{"mostrarpesos", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "mostrarpesos", "]"}]}], ",", 
                   RowBox[{"shape", "\[Rule]", 
                    RowBox[{"OptionValue", "[", "shape", "]"}]}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], ";", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "dimensions3d", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "mostrarpesos", "]"}], "]"}], "&&", 
             RowBox[{"BooleanQ", "[", 
              RowBox[{"OptionValue", "[", "shape", "]"}], "]"}]}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"OptionValue", "[", "dimensions3d", "]"}], ",", 
                RowBox[{"GrafoO3d", "[", "GGrafo", "]"}], ",", 
                RowBox[{"GrafoONo3d", "[", "GGrafo", "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"PesosAristas", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"WeightedGraphQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"AristasMixtasQ", "[", "GGrafo", "]"}], ",", 
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"Length", "[", 
                  RowBox[{"Quiet", "[", 
                   RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{"System`EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"Gicontador6_", "\[Rule]", " ", 
                    RowBox[{"NumericQ", "[", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", "Gicontador6"}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}], "]"}]}]}], "]"}], "]"}], 
                  "]"}], "\[Equal]", 
                 RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
                RowBox[{"GList3", "=", 
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}], ",", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}]}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"Gi2", ",", "1", ",", 
                    RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], "}"}]}], 
                  "]"}]}]}], "]"}], ";", 
              RowBox[{"GList4", "=", 
               RowBox[{"Select", "[", 
                RowBox[{"GList3", ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"DirectedEdge", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
              RowBox[{"GList5", "=", 
               RowBox[{
                RowBox[{"Select", "[", 
                 RowBox[{"GList3", ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"UndirectedEdge", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}], "/.", 
                RowBox[{"UndirectedEdge", "\[Rule]", "DirectedEdge"}]}]}], 
              ";", 
              RowBox[{"Join", "[", 
               RowBox[{"GList4", ",", "GList5", ",", 
                RowBox[{"Reverse", "[", 
                 RowBox[{"GList5", ",", "3"}], "]"}]}], "]"}]}], ",", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", 
                 RowBox[{"Quiet", "[", 
                  RowBox[{"Cases", "[", 
                   RowBox[{
                    RowBox[{"System`EdgeList", "[", "GGrafo", "]"}], ",", 
                    RowBox[{"Gicontador6_", "\[Rule]", " ", 
                    RowBox[{"NumericQ", "[", 
                    RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", "Gicontador6"}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}], "]"}]}]}], "]"}], "]"}], 
                 "]"}], "\[Equal]", 
                RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], ",", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}], ",", 
                   RowBox[{"PropertyValue", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"GGrafo", ",", 
                    RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafo", "]"}], "[", 
                    RowBox[{"[", "Gi2", "]"}], "]"}]}], "}"}], ",", 
                    "System`EdgeWeight"}], "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"Gi2", ",", "1", ",", 
                   RowBox[{"EdgeCount", "[", "GGrafo", "]"}]}], "}"}]}], 
                "]"}]}], "]"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GrafoCQ", "[", "GGrafo", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ListQ", "[", 
              RowBox[{"Edges", "[", 
               RowBox[{"GGrafo", ",", "EdgeWeight"}], "]"}], "]"}], ",", 
             RowBox[{"Edges", "[", 
              RowBox[{"GGrafo", ",", "EdgeWeight"}], "]"}]}], "]"}]}], 
          "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"MBooleanQ", "[", "MatrizSBooleana_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MatrixQ", "[", 
          RowBox[{"MatrizSBooleana", ",", "NumericQ"}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"Flatten", "[", "MatrizSBooleana", "]"}], ",", "Null"}],
              "]"}], "\[Equal]", "False"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"MatrizSBooleana", "^", "2"}], "==", 
              "MatrizSBooleana"}], ",", "True", ",", "False"}], "]"}], ",", 
           "False"}], "]"}], ",", "False"}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"AristasMixtasQ", "[", "GGrafo_", "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"GrafoQ", "[", "GGrafo", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"DirectedEdge", "[", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                 "#"}], "&"}]}], "]"}], "\[NotEqual]", 
             RowBox[{"{", "}"}]}], "&&", 
            RowBox[{
             RowBox[{"Select", "[", 
              RowBox[{
               RowBox[{"EdgeList", "[", "GGrafo", "]"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"UndirectedEdge", "[", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                 "#"}], "&"}]}], "]"}], "\[NotEqual]", 
             RowBox[{"{", "}"}]}]}], ",", "True", ",", "False"}], "]"}]}], 
        "]"}]}], ";", 
      RowBox[{
       RowBox[{
       "AristasMixtasWolframSystemToCombinatorica", "[", "GAristasGrafo_", 
        "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"GGrafoAuxiliar10", "=", 
           RowBox[{"System`Graph", "[", "GAristasGrafo", "]"}]}], "}"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"GraphQ", "[", "GGrafoAuxiliar10", "]"}], ",", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"AristasMixtasQ", "[", "GGrafoAuxiliar10", "]"}], ",", 
             RowBox[{"Join", "[", 
              RowBox[{
               RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                RowBox[{"Select", "[", 
                 RowBox[{
                  RowBox[{"EdgeList", "[", "GGrafoAuxiliar10", "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"DirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    "#"}], "&"}]}], "]"}], "]"}], ",", 
               RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                RowBox[{"Select", "[", 
                 RowBox[{
                  RowBox[{"EdgeList", "[", "GGrafoAuxiliar10", "]"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"UndirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    "#"}], "&"}]}], "]"}], "]"}], ",", 
               RowBox[{"Reverse", "[", 
                RowBox[{
                 RowBox[{"AristasWolframSystemToCombinatorica", "[", 
                  RowBox[{"Select", "[", 
                   RowBox[{
                    RowBox[{"EdgeList", "[", "GGrafoAuxiliar10", "]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"UndirectedEdge", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[Equal]", 
                    "#"}], "&"}]}], "]"}], "]"}], ",", "2"}], "]"}]}], 
              "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"None", ",", "None"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Column", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Spacer", "[", 
             RowBox[{"{", 
              RowBox[{"400", ",", "2"}], "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Autor: Enrique V\[IAcute]lchez Quesada\>\"", ",", "Bold", 
                ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}], 
              "}"}], "]"}], ",", 
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica\>\"", ",", "Bold", ",", "10", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.12", ",", "0", ",", "0.5"}], "]"}]}], "]"}], 
              "}"}], "]"}]}], "}"}], ",", "Center"}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\[CapitalAAcute]rboles generadores\>\"", ",", " ", "Bold", ",", 
          " ", 
          RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0.333333", ",", "0"}], "]"}]}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6786164935532165`*^9, 3.678616498058397*^9}, {
  3.6786165441578083`*^9, 3.678616581125671*^9}, {3.6786166153320656`*^9, 
  3.6786166313506126`*^9}, {3.678616677612821*^9, 3.678616679778947*^9}, {
  3.6786174504172177`*^9, 3.678617500086866*^9}, {3.6786176927976665`*^9, 
  3.6786177255027885`*^9}, {3.678617798967627*^9, 3.678617800338348*^9}, {
  3.6786180993263597`*^9, 3.6786181013296556`*^9}, {3.8011548742221694`*^9, 
  3.8011549368439064`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"1f549835-aef4-478e-b7ca-5124783becaa"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`AVl18$$ = {{$CellContext`a, \
$CellContext`b}, {$CellContext`a, $CellContext`c}, {$CellContext`a, \
$CellContext`e}, {$CellContext`b, $CellContext`d}, {$CellContext`c, \
$CellContext`e}, {$CellContext`c, $CellContext`d}, {$CellContext`c, \
$CellContext`f}, {$CellContext`e, $CellContext`f}, {$CellContext`d, \
$CellContext`f}}, $CellContext`AVl19$$ = {4, 2, 3, 5, 6, 1, 3, 2, 
    6}, $CellContext`AVl20$$ = {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d, $CellContext`e, $CellContext`f}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"sin t\[IAcute]tulo\"", Typeset`specs$$ = {{{
       Hold[$CellContext`AVl18$$], {{$CellContext`a, $CellContext`b}, \
{$CellContext`a, $CellContext`c}, {$CellContext`a, $CellContext`e}, \
{$CellContext`b, $CellContext`d}, {$CellContext`c, $CellContext`e}, \
{$CellContext`c, $CellContext`d}, {$CellContext`c, $CellContext`f}, \
{$CellContext`e, $CellContext`f}, {$CellContext`d, $CellContext`f}}, 
       "Aristas del grafo"}}, {{
       Hold[$CellContext`AVl19$$], {4, 2, 3, 5, 6, 1, 3, 2, 6}, 
       "Pesos de los lados"}}, {{
       Hold[$CellContext`AVl20$$], {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d, $CellContext`e, $CellContext`f}, 
       "Orden de los nodos"}}}, Typeset`size$$ = {713., {157., 166.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`AVl18$$ = {{$CellContext`a, \
$CellContext`b}, {$CellContext`a, $CellContext`c}, {$CellContext`a, \
$CellContext`e}, {$CellContext`b, $CellContext`d}, {$CellContext`c, \
$CellContext`e}, {$CellContext`c, $CellContext`d}, {$CellContext`c, \
$CellContext`f}, {$CellContext`e, $CellContext`f}, {$CellContext`d, \
$CellContext`f}}, $CellContext`AVl19$$ = {4, 2, 3, 5, 6, 1, 3, 2, 
         6}, $CellContext`AVl20$$ = {$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d, $CellContext`e, $CellContext`f}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[
        MatrixQ[$CellContext`AVl18$$], 
        If[MemberQ[
           ToCharacterCode[
            ToString[$CellContext`AVl18$$]], 62760] == False, 
         If[Part[
            Dimensions[$CellContext`AVl18$$], 2] == 2, 
          If[MemberQ[
             Flatten[$CellContext`AVl18$$], Null] == False, 
           If[
            VectorQ[$CellContext`AVl19$$], 
            If[MemberQ[$CellContext`AVl19$$, Null] == False, 
             If[$CellContext`AVl19$$ != {}, 
              If[Length[$CellContext`AVl18$$] == Length[$CellContext`AVl19$$], 
               If[
                VectorQ[$CellContext`AVl20$$], 
                If[MemberQ[$CellContext`AVl20$$, Null] == False, 
                 If[$CellContext`AVl20$$ != {}, 
                  If[ToString[
                    Sort[
                    DeleteDuplicates[
                    Flatten[$CellContext`AVl18$$]]]] == ToString[
                    Sort[$CellContext`AVl20$$]], 
                   Column[{
                    $CellContext`Grafo[$CellContext`AVl18$$, \
$CellContext`pesos -> $CellContext`AVl19$$, $CellContext`mostrarpesos -> 
                    True], 
                    Row[{"Buscar primero a lo ancho: ", 
                    $CellContext`BuscarPrimeroAncho[
                    $CellContext`Grafo[$CellContext`AVl18$$, \
$CellContext`pesos -> $CellContext`AVl19$$, $CellContext`mostrarpesos -> 
                    True], $CellContext`orden -> $CellContext`AVl20$$]}], 
                    Row[{"Buscar primero a lo largo: ", 
                    $CellContext`BuscarPrimeroLargo[
                    $CellContext`Grafo[$CellContext`AVl18$$, \
$CellContext`pesos -> $CellContext`AVl19$$, $CellContext`mostrarpesos -> 
                    True], $CellContext`orden -> $CellContext`AVl20$$]}], 
                    Row[{"Prim: ", 
                    If[
                    VectorQ[$CellContext`AVl19$$, NumericQ], 
                    $CellContext`OPrim[
                    $CellContext`Grafo[$CellContext`AVl18$$, \
$CellContext`pesos -> $CellContext`AVl19$$, $CellContext`mostrarpesos -> 
                    True], $CellContext`AVl20$$], ""]}], 
                    Row[{"Kruskal: ", 
                    If[
                    VectorQ[$CellContext`AVl19$$, NumericQ], 
                    $CellContext`OKruskal[
                    $CellContext`Grafo[$CellContext`AVl18$$, \
$CellContext`pesos -> $CellContext`AVl19$$, $CellContext`mostrarpesos -> 
                    True]], ""]}]}], ""], ""], ""], ""], ""], ""], ""], ""], 
           ""], ""], ""], ""], 
      "Specifications" :> {{{$CellContext`AVl18$$, {{$CellContext`a, \
$CellContext`b}, {$CellContext`a, $CellContext`c}, {$CellContext`a, \
$CellContext`e}, {$CellContext`b, $CellContext`d}, {$CellContext`c, \
$CellContext`e}, {$CellContext`c, $CellContext`d}, {$CellContext`c, \
$CellContext`f}, {$CellContext`e, $CellContext`f}, {$CellContext`d, \
$CellContext`f}}, "Aristas del grafo"}}, {{$CellContext`AVl19$$, {4, 2, 3, 5, 
          6, 1, 3, 2, 6}, 
          "Pesos de los lados"}}, {{$CellContext`AVl20$$, {$CellContext`a, \
$CellContext`b, $CellContext`c, $CellContext`d, $CellContext`e, \
$CellContext`f}, "Orden de los nodos"}}}, 
      "Options" :> {Alignment -> Center, FrameLabel -> {{None, None}, {
           Column[{
             Spacer[{400, 2}], 
             Row[{
               Style["Autor: Enrique V\[IAcute]lchez Quesada", Bold, 10, 
                RGBColor[0, 0.333333, 0]]}], 
             Row[{
               Style[
               "Escuela de Inform\[AAcute]tica | Universidad Nacional de \
Costa Rica", Bold, 10, 
                RGBColor[0.12, 0, 0.5]]}]}, Center], 
           Style["\[CapitalAAcute]rboles generadores", Bold, 
            RGBColor[0, 0.333333, 0]]}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{785., {324., 333.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>((
      Clear[$CellContext`a, $CellContext`b, $CellContext`c, $CellContext`d, \
$CellContext`e, $CellContext`f]; $CellContext`OPrim[
         Pattern[$CellContext`AGrafo, 
          Blank[]], 
         Pattern[$CellContext`AAOrden, 
          Blank[]]] := 
       Module[{$CellContext`AlgoritmoPrim}, $CellContext`AlgoritmoPrim[
            Pattern[$CellContext`AAGrafo, 
             Blank[]], 
            Pattern[$CellContext`OrdenLista, 
             Blank[]]] := 
          Module[{$CellContext`AGrafoAuxiliar3, $CellContext`APReglas}, \
$CellContext`APReglas = Table[ToString[
                 
                 Part[$CellContext`OrdenLista, $CellContext`APAi]] -> \
$CellContext`APAi, {$CellContext`APAi, 
                
                VertexCount[$CellContext`AAGrafo]}]; \
$CellContext`AGrafoAuxiliar3 = $CellContext`Grafo[
               ReplaceAll[
                Map[ToString, 
                 $CellContext`AristasWolframSystemToCombinatorica[
                  EdgeList[$CellContext`AAGrafo]], {
                 2}], $CellContext`APReglas], $CellContext`pesos -> Table[
                 Part[
                  Flatten[
                   Select[
                    $CellContext`PesosAristas[$CellContext`AAGrafo], 
                    MemberQ[#, $CellContext`APAi]& ]], 2], {$CellContext`APAi, 
                  EdgeList[$CellContext`AAGrafo]}]]; 
            Module[{$CellContext`APrimn = 
               VertexCount[$CellContext`AGrafoAuxiliar3], $CellContext`APrimm = 
               EdgeCount[$CellContext`AGrafoAuxiliar3], $CellContext`APrimT, \
$CellContext`APrimL, $CellContext`APrimMP, $CellContext`APrimAi, \
$CellContext`APLPesos, $CellContext`APPesoMin, $CellContext`APLPosPesoMin, \
$CellContext`APPosPesoMin, $CellContext`APArista, \
$CellContext`APAristasArbol, $CellContext`APPeso, $CellContext`APAristasS, \
$CellContext`APAristasSS, $CellContext`APPos1, $CellContext`APPos1Ext, \
$CellContext`APArbol, $CellContext`APNArbol, $CellContext`APContador}, \
$CellContext`APrimT = Sort[
                 
                 VertexList[$CellContext`AGrafoAuxiliar3]]; \
$CellContext`APrimL = 
               EdgeList[$CellContext`AGrafoAuxiliar3]; $CellContext`APrimMP = 
               Part[
                 $CellContext`MPGrafo[$CellContext`AGrafoAuxiliar3, \
$CellContext`APrimT], 
                 1]; $CellContext`APAristasS = {}; $CellContext`APAristasSS = \
{}; For[$CellContext`APrimAi = 1, $CellContext`APrimAi <= $CellContext`APrimn,
                 If[
                  EdgeQ[$CellContext`AGrafoAuxiliar3, 
                   UndirectedEdge[
                    Part[$CellContext`APrimT, 1], 
                    
                    Part[$CellContext`APrimT, $CellContext`APrimAi]]], \
$CellContext`APAristasS = Append[$CellContext`APAristasS, {{
                    Part[$CellContext`APrimT, 1], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]}, 
                    
                    Part[$CellContext`APrimMP, 
                    1, $CellContext`APrimAi]}]; $CellContext`APAristasSS = 
                   Append[$CellContext`APAristasSS, {
                    Part[$CellContext`APrimT, 1], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]}]]; 
                Increment[$CellContext`APrimAi]]; $CellContext`APLPesos = {}; 
              For[$CellContext`APrimAi = 1, $CellContext`APrimAi <= 
                Length[$CellContext`APAristasS], $CellContext`APLPesos = 
                 Append[$CellContext`APLPesos, 
                   Part[$CellContext`APAristasS, $CellContext`APrimAi, 2]]; 
                Increment[$CellContext`APrimAi]]; $CellContext`APPesoMin = 
               Min[$CellContext`APLPesos]; $CellContext`APLPosPesoMin = 
               Flatten[
                 
                 Position[$CellContext`APLPesos, $CellContext`APPesoMin]]; \
$CellContext`APArista = Part[
                 Sort[
                  Part[$CellContext`APAristasS, $CellContext`APLPosPesoMin]], 
                 1, 1]; $CellContext`APPosPesoMin = Part[
                 Position[$CellContext`APAristasSS, $CellContext`APArista], 1,
                  1]; $CellContext`APAristasArbol = {
                 UndirectedEdge[
                  Part[$CellContext`APArista, 1], 
                  
                  Part[$CellContext`APArista, 
                   2]]}; $CellContext`APPeso = $CellContext`APPesoMin; \
$CellContext`APArista = Last[$CellContext`APAristasArbol]; 
              For[$CellContext`APrimAi = 
                1, $CellContext`APrimAi <= $CellContext`APrimn, If[
                  And[
                   EdgeQ[$CellContext`AGrafoAuxiliar3, 
                    UndirectedEdge[
                    Part[$CellContext`APArista, 2], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]]], 
                   ToString[
                    Part[$CellContext`APArista, 1]] != ToString[
                    
                    Part[$CellContext`APrimT, $CellContext`APrimAi]]], \
$CellContext`APPos1 = Position[$CellContext`APrimT, 
                    Part[$CellContext`APArista, 2]]; $CellContext`APPos1Ext = 
                   Part[$CellContext`APPos1, 1, 1]; $CellContext`APAristasS = 
                   Append[$CellContext`APAristasS, {{
                    Part[$CellContext`APArista, 2], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]}, 
                    
                    Part[$CellContext`APrimMP, $CellContext`APPos1Ext, \
$CellContext`APrimAi]}]; $CellContext`APAristasSS = 
                   Append[$CellContext`APAristasSS, {
                    Part[$CellContext`APArista, 2], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]}]]; 
                Increment[$CellContext`APrimAi]]; $CellContext`APAristasS = 
               Delete[$CellContext`APAristasS, $CellContext`APPosPesoMin]; \
$CellContext`APAristasSS = 
               Delete[$CellContext`APAristasSS, $CellContext`APPosPesoMin]; \
$CellContext`APContador = 1; 
              While[Length[$CellContext`APAristasArbol] < $CellContext`APrimn - 
                 1, $CellContext`APLPesos = {}; 
                For[$CellContext`APrimAi = 1, $CellContext`APrimAi <= 
                  Length[$CellContext`APAristasS], $CellContext`APLPesos = 
                   Append[$CellContext`APLPesos, 
                    Part[$CellContext`APAristasS, $CellContext`APrimAi, 2]]; 
                  Increment[$CellContext`APrimAi]]; $CellContext`APPesoMin = 
                 Min[$CellContext`APLPesos]; $CellContext`APLPosPesoMin = 
                 Flatten[
                   
                   Position[$CellContext`APLPesos, $CellContext`APPesoMin]]; \
$CellContext`APArista = Part[
                   Sort[
                    
                    Part[$CellContext`APAristasS, \
$CellContext`APLPosPesoMin]], 1, 1]; $CellContext`APPosPesoMin = Part[
                   Position[$CellContext`APAristasSS, $CellContext`APArista], 
                   1, 1]; $CellContext`APNArbol = Graph[
                   Append[$CellContext`APAristasArbol, 
                    UndirectedEdge[
                    Part[$CellContext`APArista, 1], 
                    Part[$CellContext`APArista, 2]]]]; If[
                  
                  AcyclicGraphQ[$CellContext`APNArbol], \
$CellContext`APAristasArbol = Append[$CellContext`APAristasArbol, 
                    UndirectedEdge[
                    Part[$CellContext`APArista, 1], 
                    Part[$CellContext`APArista, 2]]]; $CellContext`APArbol = 
                   Graph[$CellContext`APAristasArbol, VertexLabels -> "Name", 
                    ImagePadding -> 
                    10]; $CellContext`APPeso = $CellContext`APPeso + \
$CellContext`APPesoMin; $CellContext`APAristasS = 
                   Delete[$CellContext`APAristasS, $CellContext`APPosPesoMin]; \
$CellContext`APAristasSS = 
                   Delete[$CellContext`APAristasSS, \
$CellContext`APPosPesoMin]; 
                  Increment[$CellContext`APContador]; $CellContext`APArista = 
                   Last[$CellContext`APAristasArbol]; 
                  For[$CellContext`APrimAi = 
                    1, $CellContext`APrimAi <= $CellContext`APrimn, If[
                    And[
                    EdgeQ[$CellContext`AGrafoAuxiliar3, 
                    UndirectedEdge[
                    Part[$CellContext`APArista, 2], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]]], 
                    ToString[
                    Part[$CellContext`APArista, 1]] != ToString[
                    Part[$CellContext`APrimT, $CellContext`APrimAi]], 
                    EdgeQ[$CellContext`APArbol, 
                    UndirectedEdge[
                    Part[$CellContext`APArista, 2], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]]] == 
                    False, MemberQ[$CellContext`APAristasSS, {
                    Part[$CellContext`APArista, 2], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]}] == 
                    False, MemberQ[$CellContext`APAristasSS, {
                    Part[$CellContext`APrimT, $CellContext`APrimAi], 
                    Part[$CellContext`APArista, 2]}] == 
                    False], $CellContext`APPos1 = 
                    Position[$CellContext`APrimT, 
                    Part[$CellContext`APArista, 2]]; $CellContext`APPos1Ext = 
                    Part[$CellContext`APPos1, 1, 1]; $CellContext`APAristasS = 
                    Append[$CellContext`APAristasS, {{
                    Part[$CellContext`APArista, 2], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]}, 
                    
                    Part[$CellContext`APrimMP, $CellContext`APPos1Ext, \
$CellContext`APrimAi]}]; $CellContext`APAristasSS = 
                    Append[$CellContext`APAristasSS, {
                    Part[$CellContext`APArista, 2], 
                    Part[$CellContext`APrimT, $CellContext`APrimAi]}]]; 
                    Increment[$CellContext`APrimAi]], $CellContext`APAristasS = 
                   Delete[$CellContext`APAristasS, $CellContext`APPosPesoMin]; \
$CellContext`APAristasSS = 
                   Delete[$CellContext`APAristasSS, \
$CellContext`APPosPesoMin]]]; {
                Table[{
                  If[
                   MemberQ[
                    VertexList[$CellContext`AAGrafo], 
                    Part[$CellContext`APAi, 1]], 
                   Part[$CellContext`APAi, 1], 
                   ToExpression[
                    Part[$CellContext`APAi, 1]]], 
                  If[
                   MemberQ[
                    VertexList[$CellContext`AAGrafo], 
                    Part[$CellContext`APAi, 2]], 
                   Part[$CellContext`APAi, 2], 
                   ToExpression[
                    Part[$CellContext`APAi, 2]]]}, {$CellContext`APAi, 
                  ReplaceAll[
                   $CellContext`AristasWolframSystemToCombinatorica[$\
CellContext`APAristasArbol], 
                   Map[
                   Reverse, $CellContext`APReglas]]}], $CellContext`APPeso}]]; 
         If[
           $CellContext`GrafoQ[$CellContext`AGrafo], 
           If[
            $CellContext`GrafoConexoQ[$CellContext`AGrafo], 
            If[
             Not[
              $CellContext`GrafoDirigidoQ[$CellContext`AGrafo]], 
             If[
              $CellContext`GrafoPonderadoQ[$CellContext`AGrafo], 
              If[
               VectorQ[$CellContext`AAOrden], 
               If[ToString[
                  Sort[$CellContext`AAOrden]] == ToString[
                  Sort[
                   VertexList[$CellContext`AGrafo]]], 
                If[
                 $CellContext`MBooleanQ[
                  Normal[
                   AdjacencyMatrix[$CellContext`AGrafo]]], 
                 $CellContext`AlgoritmoPrim[$CellContext`AGrafo, \
$CellContext`AAOrden]]]]]]]]]; $CellContext`OKruskal[
         Pattern[$CellContext`AGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`AGrafo], 
         If[
          $CellContext`GrafoConexoQ[$CellContext`AGrafo], 
          If[
           Not[
            $CellContext`GrafoDirigidoQ[$CellContext`AGrafo]], 
           If[
            $CellContext`GrafoPonderadoQ[$CellContext`AGrafo], 
            If[
             $CellContext`MBooleanQ[
              Normal[
               AdjacencyMatrix[$CellContext`AGrafo]]], 
             
             Module[{$CellContext`AKAristasArbol = {}, \
$CellContext`AKPesoMinimo = 
               0, $CellContext`AKLadosPesos, $CellContext`AKruskalAi, \
$CellContext`AKPesos, $CellContext`AKAristas, $CellContext`AKMinimo, \
$CellContext`AKPos1, $CellContext`AKPos2, $CellContext`AKOAristas, \
$CellContext`AKArista}, $CellContext`AKLadosPesos = \
$CellContext`PesosAristas[$CellContext`AGrafo]; $CellContext`AKPesos = Select[
                 Flatten[$CellContext`AKLadosPesos], 
                 EdgeQ[$CellContext`AGrafo, #] == 
                 False& ]; $CellContext`AKAristas = Select[
                 Flatten[$CellContext`AKLadosPesos], 
                 EdgeQ[$CellContext`AGrafo, #]& ]; $CellContext`AKruskalAi = 
               1; While[$CellContext`AKruskalAi <= 
                VertexCount[$CellContext`AGrafo] - 1, $CellContext`AKMinimo = 
                 Min[$CellContext`AKPesos]; $CellContext`AKPos1 = 
                 Position[$CellContext`AKPesos, $CellContext`AKMinimo]; \
$CellContext`AKPos2 = Flatten[
                   
                   Position[$CellContext`AKPesos, $CellContext`AKMinimo]]; \
$CellContext`AKOAristas = 
                 Part[$CellContext`AKAristas, $CellContext`AKPos2]; \
$CellContext`AKOAristas = Select[$CellContext`AKOAristas, AcyclicGraphQ[
                    Graph[
                    Append[$CellContext`AKAristasArbol, #]]]& ]; 
                If[ToString[$CellContext`AKOAristas] != 
                  ToString[{}], $CellContext`AKArista = 
                   RandomChoice[$CellContext`AKOAristas]; $CellContext`AKPos1 = 
                   Part[
                    Position[$CellContext`AKAristas, $CellContext`AKArista], 
                    1, 1]; $CellContext`AKAristasArbol = 
                   Append[$CellContext`AKAristasArbol, $CellContext`AKArista]; \
$CellContext`AKPesoMinimo = $CellContext`AKPesoMinimo + 
                    Part[$CellContext`AKLadosPesos, $CellContext`AKPos1, 
                    2]; $CellContext`AKLadosPesos = 
                   Delete[$CellContext`AKLadosPesos, $CellContext`AKPos1]; \
$CellContext`AKAristas = 
                   Delete[$CellContext`AKAristas, $CellContext`AKPos1]; \
$CellContext`AKPesos = Delete[$CellContext`AKPesos, $CellContext`AKPos1]; 
                  Increment[$CellContext`AKruskalAi], \
$CellContext`AKLadosPesos = 
                   Delete[$CellContext`AKLadosPesos, $CellContext`AKPos1]; \
$CellContext`AKAristas = 
                   Delete[$CellContext`AKAristas, $CellContext`AKPos1]; \
$CellContext`AKPesos = Delete[$CellContext`AKPesos, $CellContext`AKPos1]]]; {
                Part[
                 
                 Map[$CellContext`AristasWolframSystemToCombinatorica, \
{$CellContext`AKAristasArbol}], 1], $CellContext`AKPesoMinimo}]]]]]]; 
      Options[$CellContext`Grafo] = {$CellContext`dirigido -> 
         False, $CellContext`vertices -> {}, $CellContext`dimensions3d -> 
         False, $CellContext`pesos -> {}, $CellContext`mostrarpesos -> 
         False, $CellContext`shape -> False}; $CellContext`Grafo[
         Pattern[$CellContext`GAristas, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GAristasNoDirigidas, \
$CellContext`GAristasDirigidas, $CellContext`GLabelsPesos, \
$CellContext`Grafo3d, $CellContext`GrafoNo3d}, \
$CellContext`GAristasNoDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador4, 
               Blank[]] -> UndirectedEdge[
               Part[$CellContext`Gicontador4, 1], 
               
               Part[$CellContext`Gicontador4, 
                2]]]]; $CellContext`GAristasDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador5, 
               Blank[]] -> DirectedEdge[
               Part[$CellContext`Gicontador5, 1], 
               Part[$CellContext`Gicontador5, 2]]]]; $CellContext`GLabelsPesos[
            Pattern[$CellContext`GGrafo, 
             Blank[]], 
            Pattern[$CellContext`GPesos, 
             Blank[]]] := 
          If[Length[$CellContext`GPesos] == EdgeCount[$CellContext`GGrafo], 
            
            Module[{$CellContext`GList1 = 
              EdgeList[$CellContext`GGrafo], $CellContext`GList2 = {}}, 
             For[$CellContext`Gi1 = 1, $CellContext`Gi1 <= 
               Length[$CellContext`GList1], $CellContext`GList2 = 
                Append[$CellContext`GList2, 
                  Part[$CellContext`GList1, $CellContext`Gi1] -> 
                  Part[$CellContext`GPesos, $CellContext`Gi1]]; 
               Increment[$CellContext`Gi1]]; $CellContext`GList2]]; \
$CellContext`Grafo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Sphere[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Sphere[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph3D[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph3D[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; $CellContext`GrafoNo3d[
            Pattern[$CellContext`GOAristas, 
             Blank[]]] := Module[{$CellContext`GVl1}, 
            If[
             OptionValue[$CellContext`shape], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    
                    Text[#2, #]}& )], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1, 
                  VertexShapeFunction -> ({White, 
                    EdgeForm[Black], 
                    Disk[#, 0.1], Black, 
                    Text[#2, #]}& )]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos], 
                VertexShapeFunction -> ({White, 
                  EdgeForm[Black], 
                  Disk[#, 0.1], Black, 
                  Text[#2, #]}& )]]], 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               OptionValue[$CellContext`dirigido], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == 
                ToString[{}], $CellContext`GVl1 = $CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   ConstantArray[1, 
                    Length[$CellContext`GOAristas]]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  ConstantArray[1, 
                    Length[$CellContext`GOAristas]], 
                  EdgeLabels -> $CellContext`GVl1], $CellContext`GVl1 = \
$CellContext`GLabelsPesos[
                   Graph[
                    OptionValue[$CellContext`vertices], 
                    $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                    VertexLabels -> "Name", ImagePadding -> 10], 
                   OptionValue[$CellContext`pesos]]; Graph[
                  OptionValue[$CellContext`vertices], 
                  $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                  VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                  OptionValue[$CellContext`pesos], 
                  EdgeLabels -> $CellContext`GVl1]]], 
              If[
               OptionValue[$CellContext`dirigido], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]], 
               Graph[
                OptionValue[$CellContext`vertices], 
                $CellContext`GAristasNoDirigidas[$CellContext`GOAristas], 
                VertexLabels -> "Name", ImagePadding -> 10, EdgeWeight -> 
                OptionValue[$CellContext`pesos]]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dirigido]], 
            VectorQ[
             OptionValue[$CellContext`vertices]], 
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            VectorQ[
             OptionValue[$CellContext`pesos]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            And[MemberQ[
               OptionValue[$CellContext`vertices], Null] == False, MemberQ[
               OptionValue[$CellContext`pesos], Null] == False], 
            If[
             And[
              Or[
               MatrixQ[$CellContext`GAristas], 
               ToString[$CellContext`GAristas] == ToString[{}]], MemberQ[
                Flatten[$CellContext`GAristas], Null] == False], 
             If[
              Or[Length[$CellContext`GAristas] == Length[
                 OptionValue[$CellContext`pesos]], ToString[
                 OptionValue[$CellContext`pesos]] == ToString[{}]], 
              If[
               Or[
                And[ToString[$CellContext`GAristas] == ToString[{}], ToString[
                   OptionValue[$CellContext`vertices]] != ToString[{}]], 
                And[
                 MatrixQ[$CellContext`GAristas], Part[
                   Dimensions[$CellContext`GAristas], 2] == 2, MemberQ[
                   ToCharacterCode[
                    ToString[$CellContext`GAristas]], 62760] == False]], 
               If[
                OptionValue[$CellContext`dimensions3d], 
                $CellContext`Grafo3d[$CellContext`GAristas], 
                $CellContext`GrafoNo3d[$CellContext`GAristas]]]]]]]]; 
      Options[$CellContext`BuscarPrimeroAncho] = {$CellContext`animacion -> 
         False, $CellContext`orden -> {}}; $CellContext`BuscarPrimeroAncho[
         Pattern[$CellContext`AGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`AOPreOrden}, $CellContext`AOPreOrden[
            Pattern[$CellContext`AAGrafo, 
             Blank[]], 
            Pattern[$CellContext`ARaiz, 
             Blank[]]] := 
          Module[{$CellContext`OPrefi, $CellContext`AAList31, \
$CellContext`AList29, $CellContext`AList30, $CellContext`AAristas, \
$CellContext`AAGrafoAuxiliar1}, $CellContext`OPrefi[
               Pattern[$CellContext`AAAGrafo, 
                Blank[]], 
               Pattern[$CellContext`AARaiz, 
                Blank[]]] := 
             Module[{$CellContext`AAAList29 = {}, \
$CellContext`AAAGrafoAuxiliar1}, $CellContext`AAAGrafoAuxiliar1 = Graph[
                  VertexList[$CellContext`AAAGrafo], 
                  Sort[
                   
                   EdgeList[$CellContext`AAAGrafo]]]; $CellContext`AAAList29 = \
$CellContext`AristasWolframSystemToCombinatorica[
                  Part[
                   Reap[
                    
                    BreadthFirstScan[$CellContext`AAAGrafoAuxiliar1, \
$CellContext`AARaiz, "FrontierEdge" -> Sow]], 2, 
                   1]]; $CellContext`AAAList29]; $CellContext`AList29 = 
             If[ToString[
                 OptionValue[$CellContext`orden]] == ToString[{}], 
               VertexList[$CellContext`AAGrafo], 
               OptionValue[$CellContext`orden]]; $CellContext`AAristas = {}; 
            For[$CellContext`Ai24 = 1, $CellContext`Ai24 <= 
              Length[$CellContext`AList29], $CellContext`AAristas = 
               Append[$CellContext`AAristas, 
                 Select[
                  EdgeList[$CellContext`AAGrafo], Or[
                  Part[#, 1] == Part[$CellContext`AList29, $CellContext`Ai24],
                    Part[#, 2] == 
                   Part[$CellContext`AList29, $CellContext`Ai24]]& ]]; 
              Increment[$CellContext`Ai24]]; $CellContext`AAristas = 
             DeleteDuplicates[
               Flatten[$CellContext`AAristas]]; $CellContext`AList30 = 
             Table[ToString[
                 
                 Part[$CellContext`AList29, $CellContext`Ai24]] -> \
$CellContext`Ai24, {$CellContext`Ai24, 
                
                VertexCount[$CellContext`AAGrafo]}]; \
$CellContext`AAGrafoAuxiliar1 = $CellContext`Grafo[
               Table[
                If[Part[$CellContext`Ai27, 1] > Part[$CellContext`Ai27, 2], 
                 
                 Reverse[$CellContext`Ai27], $CellContext`Ai27], \
{$CellContext`Ai27, 
                 ReplaceAll[
                  Table[{
                    ToString[
                    Part[$CellContext`Ai24, 1]], 
                    ToString[
                    Part[$CellContext`Ai24, 2]]}, {$CellContext`Ai24, 
                    $CellContext`AristasWolframSystemToCombinatorica[$\
CellContext`AAristas]}], $CellContext`AList30]}]]; $CellContext`AAList31 = 
             ReplaceAll[
               $CellContext`OPrefi[$CellContext`AAGrafoAuxiliar1, 
                Part[
                 Part[
                  
                  Select[$CellContext`AList30, Part[#, 1] == 
                   ToString[$CellContext`ARaiz]& ], 1], 2]], 
               Map[Reverse, $CellContext`AList30]]; $CellContext`AAList31 = 
             Table[
               If[
                MemberQ[
                 
                 VertexList[$CellContext`AAGrafo], $CellContext`Ai24], \
$CellContext`Ai24, 
                
                ToExpression[$CellContext`Ai24]], {$CellContext`Ai24, \
$CellContext`AAList31}]; $CellContext`AAList31]; If[
           BooleanQ[
            OptionValue[$CellContext`animacion]], 
           If[
            VectorQ[
             OptionValue[$CellContext`orden]], 
            If[
             $CellContext`GrafoQ[$CellContext`AGrafo], 
             If[
              Not[
               $CellContext`GrafoDirigidoQ[$CellContext`AGrafo]], 
              If[
               $CellContext`GrafoConexoQ[$CellContext`AGrafo], 
               If[
                Or[ToString[
                   Sort[
                    OptionValue[$CellContext`orden]]] == ToString[
                   Sort[
                    VertexList[$CellContext`AGrafo]]], ToString[
                   OptionValue[$CellContext`orden]] == 
                 ToString[{}]], $CellContext`AList31 = \
$CellContext`AOPreOrden[$CellContext`AGrafo, 
                   If[ToString[
                    OptionValue[$CellContext`orden]] == ToString[{}], 
                    First[
                    VertexList[$CellContext`AGrafo]], 
                    First[
                    OptionValue[$CellContext`orden]]]]; If[
                  OptionValue[$CellContext`animacion], 
                  Print[$CellContext`AList31]; \
$CellContext`AnimarGrafo[$CellContext`AGrafo, $CellContext`AList31], \
$CellContext`AList31]]]], 
             If[
              $CellContext`GrafoCQ[$CellContext`AGrafo], 
              If[
               Not[
                $CellContext`GrafoDirigidoQ[$CellContext`AGrafo]], 
               If[
                $CellContext`GrafoConexoQ[$CellContext`AGrafo], \
$CellContext`AGrafoAuxiliar1 = $CellContext`Grafo[
                   $CellContext`Edges[$CellContext`AGrafo]]; If[
                  Or[ToString[
                    Sort[
                    OptionValue[$CellContext`orden]]] == ToString[
                    Sort[
                    VertexList[$CellContext`AGrafoAuxiliar1]]], ToString[
                    OptionValue[$CellContext`orden]] == 
                   ToString[{}]], $CellContext`AList31 = \
$CellContext`AOPreOrden[$CellContext`AGrafoAuxiliar1, 
                    If[ToString[
                    OptionValue[$CellContext`orden]] == ToString[{}], 
                    First[
                    VertexList[$CellContext`AGrafoAuxiliar1]], 
                    First[
                    OptionValue[$CellContext`orden]]]]; If[
                    OptionValue[$CellContext`animacion], 
                    Print[$CellContext`AList31]; \
$CellContext`AnimarGrafoWithCombinatorica[$CellContext`AGrafo, \
$CellContext`AList31], $CellContext`AList31]]]]]]]]]; \
$CellContext`AristasWolframSystemToCombinatorica[
         Pattern[$CellContext`GAristasGrafo, 
          Blank[]]] := 
       Module[{$CellContext`GGrafoAuxiliar1 = 
          Graph[$CellContext`GAristasGrafo]}, 
         If[
          GraphQ[$CellContext`GGrafoAuxiliar1], 
          Quiet[
           Cases[$CellContext`GAristasGrafo, Pattern[$CellContext`Gicontador1, 
              Blank[]] -> {
              Part[$CellContext`Gicontador1, 1], 
              Part[$CellContext`Gicontador1, 2]}]]]]; $CellContext`GrafoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         GraphQ[$CellContext`GGrafo], True, False]; $CellContext`GrafoCQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         NumericQ[
          $CellContext`V[$CellContext`GGrafo]], 
         If[$CellContext`V[$CellContext`GGrafo] == 0, False, True], 
         False]; $CellContext`GrafoDirigidoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          UndirectedGraphQ[$CellContext`GGrafo], False, True], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           $CellContext`UndirectedQ[$CellContext`GGrafo], False, 
           True]]]; $CellContext`GrafoConexoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          ConnectedGraphQ[$CellContext`GGrafo], True, False], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           $CellContext`ConnectedQ[$CellContext`GGrafo], True, False]]]; 
      Options[$CellContext`BuscarPrimeroLargo] = {$CellContext`animacion -> 
         False, $CellContext`orden -> {}}; $CellContext`BuscarPrimeroLargo[
         Pattern[$CellContext`AGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`AOOPreOrden}, $CellContext`AOOPreOrden[
            Pattern[$CellContext`AAGrafo, 
             Blank[]], 
            Pattern[$CellContext`ARaiz, 
             Blank[]]] := 
          Module[{$CellContext`OOPrefi, $CellContext`AAList32, \
$CellContext`AList33, $CellContext`AList34, $CellContext`AAristas, \
$CellContext`AAGrafoAuxiliar2}, $CellContext`OOPrefi[
               Pattern[$CellContext`AAAGrafo, 
                Blank[]], 
               Pattern[$CellContext`AARaiz, 
                Blank[]]] := 
             Module[{$CellContext`AAAList32 = {}, \
$CellContext`AAAGrafoAuxiliar2}, $CellContext`AAAGrafoAuxiliar2 = Graph[
                  VertexList[$CellContext`AAAGrafo], 
                  Sort[
                   
                   EdgeList[$CellContext`AAAGrafo]]]; $CellContext`AAAList32 = \
$CellContext`AristasWolframSystemToCombinatorica[
                  Part[
                   Reap[
                    
                    DepthFirstScan[$CellContext`AAAGrafoAuxiliar2, \
$CellContext`AARaiz, "FrontierEdge" -> Sow]], 2, 
                   1]]; $CellContext`AAAList32]; $CellContext`AList33 = 
             If[ToString[
                 OptionValue[$CellContext`orden]] == ToString[{}], 
               VertexList[$CellContext`AAGrafo], 
               OptionValue[$CellContext`orden]]; $CellContext`AAristas = {}; 
            For[$CellContext`Ai25 = 1, $CellContext`Ai25 <= 
              Length[$CellContext`AList33], $CellContext`AAristas = 
               Append[$CellContext`AAristas, 
                 Select[
                  EdgeList[$CellContext`AAGrafo], Or[
                  Part[#, 1] == Part[$CellContext`AList33, $CellContext`Ai25],
                    Part[#, 2] == 
                   Part[$CellContext`AList33, $CellContext`Ai25]]& ]]; 
              Increment[$CellContext`Ai25]]; $CellContext`AAristas = 
             DeleteDuplicates[
               Flatten[$CellContext`AAristas]]; $CellContext`AList34 = 
             Table[ToString[
                 
                 Part[$CellContext`AList33, $CellContext`Ai25]] -> \
$CellContext`Ai25, {$CellContext`Ai25, 
                
                VertexCount[$CellContext`AAGrafo]}]; \
$CellContext`AAGrafoAuxiliar2 = $CellContext`Grafo[
               Table[
                If[Part[$CellContext`Ai26, 1] > Part[$CellContext`Ai26, 2], 
                 
                 Reverse[$CellContext`Ai26], $CellContext`Ai26], \
{$CellContext`Ai26, 
                 ReplaceAll[
                  Table[{
                    ToString[
                    Part[$CellContext`Ai25, 1]], 
                    ToString[
                    Part[$CellContext`Ai25, 2]]}, {$CellContext`Ai25, 
                    $CellContext`AristasWolframSystemToCombinatorica[$\
CellContext`AAristas]}], $CellContext`AList34]}]]; $CellContext`AAList32 = 
             ReplaceAll[
               $CellContext`OOPrefi[$CellContext`AAGrafoAuxiliar2, 
                Part[
                 Part[
                  
                  Select[$CellContext`AList34, Part[#, 1] == 
                   ToString[$CellContext`ARaiz]& ], 1], 2]], 
               Map[Reverse, $CellContext`AList34]]; $CellContext`AAList32 = 
             Table[
               If[
                MemberQ[
                 
                 VertexList[$CellContext`AAGrafo], $CellContext`Ai25], \
$CellContext`Ai25, 
                
                ToExpression[$CellContext`Ai25]], {$CellContext`Ai25, \
$CellContext`AAList32}]; $CellContext`AAList32]; If[
           BooleanQ[
            OptionValue[$CellContext`animacion]], 
           If[
            VectorQ[
             OptionValue[$CellContext`orden]], 
            If[
             $CellContext`GrafoQ[$CellContext`AGrafo], 
             If[
              Not[
               $CellContext`GrafoDirigidoQ[$CellContext`AGrafo]], 
              If[
               $CellContext`GrafoConexoQ[$CellContext`AGrafo], 
               If[
                Or[ToString[
                   Sort[
                    OptionValue[$CellContext`orden]]] == ToString[
                   Sort[
                    VertexList[$CellContext`AGrafo]]], ToString[
                   OptionValue[$CellContext`orden]] == 
                 ToString[{}]], $CellContext`AList32 = \
$CellContext`AOOPreOrden[$CellContext`AGrafo, 
                   If[ToString[
                    OptionValue[$CellContext`orden]] == ToString[{}], 
                    First[
                    VertexList[$CellContext`AGrafo]], 
                    First[
                    OptionValue[$CellContext`orden]]]]; If[
                  OptionValue[$CellContext`animacion], 
                  Print[$CellContext`AList32]; \
$CellContext`AnimarGrafo[$CellContext`AGrafo, $CellContext`AList32], \
$CellContext`AList32]]]], 
             If[
              $CellContext`GrafoCQ[$CellContext`AGrafo], 
              If[
               Not[
                $CellContext`GrafoDirigidoQ[$CellContext`AGrafo]], 
               If[
                $CellContext`GrafoConexoQ[$CellContext`AGrafo], \
$CellContext`AGrafoAuxiliar2 = $CellContext`Grafo[
                   $CellContext`Edges[$CellContext`AGrafo]]; If[
                  Or[ToString[
                    Sort[
                    OptionValue[$CellContext`orden]]] == ToString[
                    Sort[
                    VertexList[$CellContext`AGrafoAuxiliar2]]], ToString[
                    OptionValue[$CellContext`orden]] == 
                   ToString[{}]], $CellContext`AList32 = \
$CellContext`AOOPreOrden[$CellContext`AGrafoAuxiliar2, 
                    If[ToString[
                    OptionValue[$CellContext`orden]] == ToString[{}], 
                    First[
                    VertexList[$CellContext`AGrafoAuxiliar2]], 
                    First[
                    OptionValue[$CellContext`orden]]]]; If[
                    OptionValue[$CellContext`animacion], 
                    Print[$CellContext`AList32]; \
$CellContext`AnimarGrafoWithCombinatorica[$CellContext`AGrafo, \
$CellContext`AList32], $CellContext`AList32]]]]]]]]]; $CellContext`AnimarGrafo[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         Pattern[$CellContext`GLista, 
          Blank[]]] := If[
         MatrixQ[$CellContext`GLista], 
         If[MemberQ[
            Flatten[$CellContext`GLista], Null] == False, 
          If[MemberQ[
             ToCharacterCode[
              ToString[$CellContext`GLista]], 62760] == False, 
           If[Part[
              Dimensions[$CellContext`GLista], 2] == 2, 
            If[
             $CellContext`GrafoQ[$CellContext`GGrafo], 
             If[
              $CellContext`AristasMixtasQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar12 = $CellContext`Grafo[
                 $CellContext`AristasMixtasWolframSystemToCombinatorica[
                  EdgeList[$CellContext`GGrafo]], $CellContext`dirigido -> 
                 True, $CellContext`vertices -> 
                 VertexList[$CellContext`GGrafo]]; $CellContext`GList6 = \
$CellContext`AristasCombinatoricaToWolframSystem[$CellContext`GLista, \
$CellContext`dirigido -> True]; Print[
                Manipulate[
                 HighlightGraph[$CellContext`GGrafoAuxiliar12, 
                  Cases[$CellContext`GList6, 
                   Condition[
                    Pattern[$CellContext`Gicontador10, 
                    Blank[]], 
                    MemberQ[
                    
                    Table[$CellContext`Gi14, {$CellContext`Gi14, \
$CellContext`Gi13}], 
                    Part[
                    Flatten[
                    Position[$CellContext`GList6, $CellContext`Gicontador10]],
                     1]]]], VertexLabels -> "Name", ImagePadding -> 10, 
                  GraphHighlightStyle -> 
                  "Thick"], {{$CellContext`Gi13, 1, "Aristas"}, 1, 
                  Length[$CellContext`GList6], 1}]], If[
                
                UndirectedGraphQ[$CellContext`GGrafo], $CellContext`GList6 = \
$CellContext`AristasCombinatoricaToWolframSystem[$CellContext`GLista], \
$CellContext`GList6 = \
$CellContext`AristasCombinatoricaToWolframSystem[$CellContext`GLista, \
$CellContext`dirigido -> True]]; $CellContext`GGrafoAuxiliar12 = 
               Graph[$CellContext`GGrafo]; Print[
                Manipulate[
                 HighlightGraph[$CellContext`GGrafoAuxiliar12, 
                  Cases[$CellContext`GList6, 
                   Condition[
                    Pattern[$CellContext`Gicontador10, 
                    Blank[]], 
                    MemberQ[
                    
                    Table[$CellContext`Gi14, {$CellContext`Gi14, \
$CellContext`Gi13}], 
                    Part[
                    Flatten[
                    Position[$CellContext`GList6, $CellContext`Gicontador10]],
                     1]]]], VertexLabels -> "Name", ImagePadding -> 10, 
                  GraphHighlightStyle -> 
                  "Thick"], {{$CellContext`Gi13, 1, "Aristas"}, 1, 
                  Length[$CellContext`GList6], 1}]]], 
             If[
              $CellContext`GrafoCQ[$CellContext`GGrafo], 
              $CellContext`AnimateGraph[$CellContext`GGrafo, \
$CellContext`GLista, $CellContext`VertexLabel -> True, PlotRange -> 
               0.1, $CellContext`HighlightedEdgeColors -> 
               Green]]]]]]]; $CellContext`AnimarGrafoWithCombinatorica[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         Pattern[$CellContext`GLista, 
          Blank[]]] := If[
         MatrixQ[$CellContext`GLista], 
         If[MemberQ[
            Flatten[$CellContext`GLista], Null] == False, 
          If[MemberQ[
             ToCharacterCode[
              ToString[$CellContext`GLista]], 62760] == False, 
           If[Part[
              Dimensions[$CellContext`GLista], 2] == 2, 
            If[
             $CellContext`GrafoQ[$CellContext`GGrafo], Clear[$CellContext`G]; 
             If[MemberQ[{
                  $CellContext`GraphToCombinatorica[$CellContext`GGrafo]}, 
                 Null] == 
               False, $CellContext`GraphToCombinatorica[$CellContext`GGrafo]; \
$CellContext`AnimateGraph[$CellContext`G, $CellContext`GLista, \
$CellContext`VertexLabel -> True, PlotRange -> 
                 0.1, $CellContext`EdgeLabelColor -> 
                 Red, $CellContext`HighlightedEdgeColors -> Green]], 
             If[
              $CellContext`GrafoCQ[$CellContext`GGrafo], 
              $CellContext`AnimateGraph[$CellContext`GGrafo, \
$CellContext`GLista, $CellContext`VertexLabel -> True, PlotRange -> 
               0.1, $CellContext`EdgeLabelColor -> 
               Red, $CellContext`HighlightedEdgeColors -> Green]]]]]]]; 
      Options[$CellContext`AristasCombinatoricaToWolframSystem] = \
{$CellContext`dirigido -> 
         False}; $CellContext`AristasCombinatoricaToWolframSystem[
         Pattern[$CellContext`GAristasGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GAristasNoDirigidas, \
$CellContext`GAristasDirigidas}, $CellContext`GAristasNoDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador2, 
               Blank[]] -> UndirectedEdge[
               Part[$CellContext`Gicontador2, 1], 
               
               Part[$CellContext`Gicontador2, 
                2]]]]; $CellContext`GAristasDirigidas[
            Pattern[$CellContext`GOAritas, 
             Blank[]]] := Quiet[
            Cases[$CellContext`GOAritas, Pattern[$CellContext`Gicontador3, 
               Blank[]] -> DirectedEdge[
               Part[$CellContext`Gicontador3, 1], 
               Part[$CellContext`Gicontador3, 2]]]]; If[
           MatrixQ[$CellContext`GAristasGrafo], 
           If[MemberQ[
              ToCharacterCode[
               ToString[$CellContext`GAristasGrafo]], 62760] == False, 
            If[MemberQ[
               Flatten[$CellContext`GAristasGrafo], Null] == False, 
             If[Part[
                Dimensions[$CellContext`GAristasGrafo], 2] == 2, 
              If[
               BooleanQ[
                OptionValue[$CellContext`dirigido]], 
               If[
                OptionValue[$CellContext`dirigido], 
                $CellContext`GAristasDirigidas[$CellContext`GAristasGrafo], 
                $CellContext`GAristasNoDirigidas[$CellContext`GAristasGrafo]]]\
]]]]]; Options[$CellContext`GraphToCombinatorica] = \
{$CellContext`mostrarpesos -> False}; $CellContext`GraphToCombinatorica[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GrafoCOO}, 
         Clear[$CellContext`G]; $CellContext`GrafoCOO[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl3 = If[
               $CellContext`AristasMixtasQ[$CellContext`GOGrafo], 
               $CellContext`AristasMixtasWolframSystemToCombinatorica[
                EdgeList[$CellContext`GOGrafo]], 
               $CellContext`AristasWolframSystemToCombinatorica[
                
                EdgeList[$CellContext`GOGrafo]]], $CellContext`GVl4, \
$CellContext`GGrafoAuxiliar11}, 
            If[
             UndirectedGraphQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl4 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl4 = 
               Select[$CellContext`GVl4, EdgeQ[$CellContext`GOGrafo, #] == 
                 False& ]; If[
                
                VectorQ[$CellContext`GVl4, 
                 NumericQ], $CellContext`GrafoC[$CellContext`GVl3, \
$CellContext`dirigido -> False, 
                  
                  If[$CellContext`GVl3 == {}, $CellContext`vertices -> 
                   VertexCount[$CellContext`GOGrafo], $CellContext`vertices -> 
                   0], $CellContext`pesos -> $CellContext`GVl4, \
$CellContext`mostrarpesos -> OptionValue[$CellContext`mostrarpesos]]; 
                If[$CellContext`V[$CellContext`G] == 
                  VertexCount[$CellContext`GOGrafo], 
                  $CellContext`GrafoC[$CellContext`GVl3, \
$CellContext`dirigido -> False, 
                   
                   If[$CellContext`GVl3 == {}, $CellContext`vertices -> 
                    VertexCount[$CellContext`GOGrafo], $CellContext`vertices -> 
                    0], $CellContext`pesos -> $CellContext`GVl4, \
$CellContext`mostrarpesos -> OptionValue[$CellContext`mostrarpesos]], 
                  $CellContext`GrafoC[$CellContext`GVl3, \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                   VertexCount[$CellContext`GOGrafo] - \
$CellContext`V[$CellContext`G], $CellContext`pesos -> $CellContext`GVl4, \
$CellContext`mostrarpesos -> 
                   OptionValue[$CellContext`mostrarpesos]]]], \
$CellContext`GrafoC[$CellContext`GVl3, $CellContext`dirigido -> False, 
                
                If[$CellContext`GVl3 == {}, $CellContext`vertices -> 
                 VertexCount[$CellContext`GOGrafo], $CellContext`vertices -> 
                 0], $CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos]]; 
              If[$CellContext`V[$CellContext`G] == 
                VertexCount[$CellContext`GOGrafo], 
                $CellContext`GrafoC[$CellContext`GVl3, $CellContext`dirigido -> 
                 False, 
                 
                 If[$CellContext`GVl3 == {}, $CellContext`vertices -> 
                  VertexCount[$CellContext`GOGrafo], $CellContext`vertices -> 
                  0], $CellContext`mostrarpesos -> 
                 OptionValue[$CellContext`mostrarpesos]], 
                $CellContext`GrafoC[$CellContext`GVl3, $CellContext`dirigido -> 
                 False, $CellContext`vertices -> 
                 VertexCount[$CellContext`GOGrafo] - \
$CellContext`V[$CellContext`G], $CellContext`mostrarpesos -> 
                 OptionValue[$CellContext`mostrarpesos]]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl4 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GGrafoAuxiliar11 = Graph[
                 $CellContext`AristasCombinatoricaToWolframSystem[$\
CellContext`GVl3, $CellContext`dirigido -> True]]; $CellContext`GVl4 = 
               Select[$CellContext`GVl4, 
                 EdgeQ[$CellContext`GGrafoAuxiliar11, #] == False& ]; If[
                
                VectorQ[$CellContext`GVl4, 
                 NumericQ], $CellContext`GrafoC[$CellContext`GVl3, \
$CellContext`dirigido -> True, 
                  
                  If[$CellContext`GVl3 == {}, $CellContext`vertices -> 
                   VertexCount[$CellContext`GOGrafo], $CellContext`vertices -> 
                   0], $CellContext`pesos -> $CellContext`GVl4, \
$CellContext`mostrarpesos -> OptionValue[$CellContext`mostrarpesos]]; 
                If[$CellContext`V[$CellContext`G] == 
                  VertexCount[$CellContext`GOGrafo], 
                  $CellContext`GrafoC[$CellContext`GVl3, \
$CellContext`dirigido -> True, 
                   
                   If[$CellContext`GVl3 == {}, $CellContext`vertices -> 
                    VertexCount[$CellContext`GOGrafo], $CellContext`vertices -> 
                    0], $CellContext`pesos -> $CellContext`GVl4, \
$CellContext`mostrarpesos -> OptionValue[$CellContext`mostrarpesos]], 
                  $CellContext`GrafoC[$CellContext`GVl3, \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                   VertexCount[$CellContext`GOGrafo] - \
$CellContext`V[$CellContext`G], $CellContext`pesos -> $CellContext`GVl4, \
$CellContext`mostrarpesos -> 
                   OptionValue[$CellContext`mostrarpesos]]]], \
$CellContext`GrafoC[$CellContext`GVl3, $CellContext`dirigido -> True, 
                
                If[$CellContext`GVl3 == {}, $CellContext`vertices -> 
                 VertexCount[$CellContext`GOGrafo], $CellContext`vertices -> 
                 0], $CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos]]; 
              If[$CellContext`V[$CellContext`G] == 
                VertexCount[$CellContext`GOGrafo], 
                $CellContext`GrafoC[$CellContext`GVl3, $CellContext`dirigido -> 
                 True, 
                 
                 If[$CellContext`GVl3 == {}, $CellContext`vertices -> 
                  VertexCount[$CellContext`GOGrafo], $CellContext`vertices -> 
                  0], $CellContext`mostrarpesos -> 
                 OptionValue[$CellContext`mostrarpesos]], 
                $CellContext`GrafoC[$CellContext`GVl3, $CellContext`dirigido -> 
                 True, $CellContext`vertices -> 
                 VertexCount[$CellContext`GOGrafo] - \
$CellContext`V[$CellContext`G], $CellContext`mostrarpesos -> 
                 OptionValue[$CellContext`mostrarpesos]]]]]]; If[
           BooleanQ[
            OptionValue[$CellContext`mostrarpesos]], 
           If[
            $CellContext`GrafoQ[$CellContext`GGrafo], 
            If[
             VectorQ[
              VertexList[$CellContext`GGrafo], IntegerQ], 
             If[Sort[
                VertexList[$CellContext`GGrafo]] == 
              Table[$CellContext`Gi3, {$CellContext`Gi3, 1, 
                 VertexCount[$CellContext`GGrafo]}], 
              $CellContext`GrafoCOO[$CellContext`GGrafo]]]]]]; 
      Options[$CellContext`GrafoC] = {$CellContext`dirigido -> 
         False, $CellContext`vertices -> 
         0, $CellContext`pesos -> {}, $CellContext`mostrarpesos -> 
         False}; $CellContext`GrafoC[
         Pattern[$CellContext`GAristas, 
          Blank[]], 
         OptionsPattern[]] := If[
         Or[ToString[
            OptionValue[$CellContext`pesos]] == ToString[{}], 
          VectorQ[
           OptionValue[$CellContext`pesos], NumericQ]], 
         Module[{$CellContext`GrafoCO}, 
          Clear[$CellContext`G]; $CellContext`GrafoCO[
             Pattern[$CellContext`GOAristas, 
              Blank[]]] := Module[{}, 
             If[
              OptionValue[$CellContext`mostrarpesos], 
              If[
               And[
                
                OptionValue[$CellContext`dirigido], $CellContext`GOAristas != \
{}], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == ToString[{}], 
                If[
                OptionValue[$CellContext`vertices] == 
                 0, $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromOrderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeLabels[$CellContext`G, 
                    $CellContext`GetEdgeWeights[$CellContext`G]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 0.1, $CellContext`EdgeLabel -> 
                   True, $CellContext`EdgeLabelColor -> 
                   Red], $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromOrderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`AddVertices[$CellContext`G, 
                    RandomReal[{
                    Min[
                    $CellContext`Vertices[$CellContext`G]], 
                    Max[
                    $CellContext`Vertices[$CellContext`G]]}, {
                    OptionValue[$CellContext`vertices], 
                    2}]]; $CellContext`G = \
$CellContext`SetEdgeLabels[$CellContext`G, 
                    $CellContext`GetEdgeWeights[$CellContext`G]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 0.1, $CellContext`EdgeLabel -> 
                   True, $CellContext`EdgeLabelColor -> Red]], 
                If[
                OptionValue[$CellContext`vertices] == 
                 0, $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromOrderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeWeights[$CellContext`G, 
                    
                    OptionValue[$CellContext`pesos]]; $CellContext`G = \
$CellContext`SetEdgeLabels[$CellContext`G, 
                    $CellContext`GetEdgeWeights[$CellContext`G]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 0.1, $CellContext`EdgeLabel -> 
                   True, $CellContext`EdgeLabelColor -> 
                   Red], $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromOrderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeWeights[$CellContext`G, 
                    
                    OptionValue[$CellContext`pesos]]; $CellContext`G = \
$CellContext`AddVertices[$CellContext`G, 
                    RandomReal[{
                    Min[
                    $CellContext`Vertices[$CellContext`G]], 
                    Max[
                    $CellContext`Vertices[$CellContext`G]]}, {
                    OptionValue[$CellContext`vertices], 
                    2}]]; $CellContext`G = \
$CellContext`SetEdgeLabels[$CellContext`G, 
                    $CellContext`GetEdgeWeights[$CellContext`G]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 0.1, $CellContext`EdgeLabel -> 
                   True, $CellContext`EdgeLabelColor -> Red]]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == ToString[{}], 
                If[
                OptionValue[$CellContext`vertices] == 
                 0, $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromUnorderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeLabels[$CellContext`G, 
                    $CellContext`GetEdgeWeights[$CellContext`G]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 0.1, $CellContext`EdgeLabel -> 
                   True, $CellContext`EdgeLabelColor -> 
                   Red], $CellContext`G = $CellContext`SetGraphOptions[
                    If[$CellContext`GOAristas != {}, 
                    $CellContext`FromUnorderedPairs[$CellContext`GOAristas], 
                    $CellContext`EmptyGraph[
                    
                    OptionValue[$CellContext`vertices]]], \
$CellContext`VertexColor -> Blue, EdgeColor -> Black]; 
                 If[$CellContext`GOAristas != {}, $CellContext`G = \
$CellContext`AddVertices[$CellContext`G, 
                    RandomReal[{
                    Min[
                    $CellContext`Vertices[$CellContext`G]], 
                    Max[
                    $CellContext`Vertices[$CellContext`G]]}, {
                    OptionValue[$CellContext`vertices], 
                    2}]]]; $CellContext`G = \
$CellContext`SetEdgeLabels[$CellContext`G, 
                    $CellContext`GetEdgeWeights[$CellContext`G]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 0.1, $CellContext`EdgeLabel -> 
                   True, $CellContext`EdgeLabelColor -> Red]], 
                If[
                OptionValue[$CellContext`vertices] == 
                 0, $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromUnorderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeWeights[$CellContext`G, 
                    
                    OptionValue[$CellContext`pesos]]; $CellContext`G = \
$CellContext`SetEdgeLabels[$CellContext`G, 
                    $CellContext`GetEdgeWeights[$CellContext`G]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 0.1, $CellContext`EdgeLabel -> 
                   True, $CellContext`EdgeLabelColor -> 
                   Red], $CellContext`G = $CellContext`SetGraphOptions[
                    If[$CellContext`GOAristas != {}, 
                    $CellContext`FromUnorderedPairs[$CellContext`GOAristas], 
                    $CellContext`EmptyGraph[
                    
                    OptionValue[$CellContext`vertices]]], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeWeights[$CellContext`G, 
                    OptionValue[$CellContext`pesos]]; 
                 If[$CellContext`GOAristas != {}, $CellContext`G = \
$CellContext`AddVertices[$CellContext`G, 
                    RandomReal[{
                    Min[
                    $CellContext`Vertices[$CellContext`G]], 
                    Max[
                    $CellContext`Vertices[$CellContext`G]]}, {
                    OptionValue[$CellContext`vertices], 
                    2}]]]; $CellContext`G = \
$CellContext`SetEdgeLabels[$CellContext`G, 
                    $CellContext`GetEdgeWeights[$CellContext`G]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 0.1, $CellContext`EdgeLabel -> 
                   True, $CellContext`EdgeLabelColor -> Red]]]], 
              If[
               And[
                
                OptionValue[$CellContext`dirigido], $CellContext`GOAristas != \
{}], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == ToString[{}], 
                If[
                OptionValue[$CellContext`vertices] == 
                 0, $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromOrderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`ShowGraph[$CellContext`G, \
$CellContext`VertexLabel -> True, PlotRange -> 
                   0.1], $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromOrderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`AddVertices[$CellContext`G, 
                    RandomReal[{
                    Min[
                    $CellContext`Vertices[$CellContext`G]], 
                    Max[
                    $CellContext`Vertices[$CellContext`G]]}, {
                    OptionValue[$CellContext`vertices], 
                    2}]]; $CellContext`ShowGraph[$CellContext`G, \
$CellContext`VertexLabel -> True, PlotRange -> 0.1]], 
                If[
                OptionValue[$CellContext`vertices] == 
                 0, $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromOrderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeWeights[$CellContext`G, 
                    
                    OptionValue[$CellContext`pesos]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 
                   0.1], $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromOrderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeWeights[$CellContext`G, 
                    
                    OptionValue[$CellContext`pesos]]; $CellContext`G = \
$CellContext`AddVertices[$CellContext`G, 
                    RandomReal[{
                    Min[
                    $CellContext`Vertices[$CellContext`G]], 
                    Max[
                    $CellContext`Vertices[$CellContext`G]]}, {
                    OptionValue[$CellContext`vertices], 
                    
                    2}]]; $CellContext`ShowGraph[$CellContext`G, \
$CellContext`VertexLabel -> True, PlotRange -> 0.1]]], 
               If[ToString[
                  OptionValue[$CellContext`pesos]] == ToString[{}], 
                If[
                OptionValue[$CellContext`vertices] == 
                 0, $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromUnorderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`ShowGraph[$CellContext`G, \
$CellContext`VertexLabel -> True, PlotRange -> 
                   0.1], $CellContext`G = $CellContext`SetGraphOptions[
                    If[$CellContext`GOAristas != {}, 
                    $CellContext`FromUnorderedPairs[$CellContext`GOAristas], 
                    $CellContext`EmptyGraph[
                    
                    OptionValue[$CellContext`vertices]]], \
$CellContext`VertexColor -> Blue, EdgeColor -> Black]; 
                 If[$CellContext`GOAristas != {}, $CellContext`G = \
$CellContext`AddVertices[$CellContext`G, 
                    RandomReal[{
                    Min[
                    $CellContext`Vertices[$CellContext`G]], 
                    Max[
                    $CellContext`Vertices[$CellContext`G]]}, {
                    OptionValue[$CellContext`vertices], 
                    2}]]]; $CellContext`ShowGraph[$CellContext`G, \
$CellContext`VertexLabel -> True, PlotRange -> 0.1]], 
                If[
                OptionValue[$CellContext`vertices] == 
                 0, $CellContext`G = $CellContext`SetGraphOptions[
                    $CellContext`FromUnorderedPairs[$CellContext`GOAristas], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeWeights[$CellContext`G, 
                    
                    OptionValue[$CellContext`pesos]]; \
$CellContext`ShowGraph[$CellContext`G, $CellContext`VertexLabel -> True, 
                   PlotRange -> 
                   0.1], $CellContext`G = $CellContext`SetGraphOptions[
                    If[$CellContext`GOAristas != {}, 
                    $CellContext`FromUnorderedPairs[$CellContext`GOAristas], 
                    $CellContext`EmptyGraph[
                    
                    OptionValue[$CellContext`vertices]]], \
$CellContext`VertexColor -> Blue, EdgeColor -> 
                    Black]; $CellContext`G = \
$CellContext`SetEdgeWeights[$CellContext`G, 
                    OptionValue[$CellContext`pesos]]; 
                 If[$CellContext`GOAristas != {}, $CellContext`G = \
$CellContext`AddVertices[$CellContext`G, 
                    RandomReal[{
                    Min[
                    $CellContext`Vertices[$CellContext`G]], 
                    Max[
                    $CellContext`Vertices[$CellContext`G]]}, {
                    OptionValue[$CellContext`vertices], 
                    2}]]]; $CellContext`ShowGraph[$CellContext`G, \
$CellContext`VertexLabel -> True, PlotRange -> 0.1]]]]]]; If[
            And[
             BooleanQ[
              OptionValue[$CellContext`dirigido]], 
             IntegerQ[
              OptionValue[$CellContext`vertices]], 
             VectorQ[
              OptionValue[$CellContext`pesos]], 
             BooleanQ[
              OptionValue[$CellContext`mostrarpesos]]], 
            If[
             And[OptionValue[$CellContext`vertices] >= 0, MemberQ[
                OptionValue[$CellContext`pesos], Null] == False], 
             If[
              And[
               Or[
                MatrixQ[$CellContext`GAristas], 
                ToString[$CellContext`GAristas] == ToString[{}]], MemberQ[
                 Flatten[$CellContext`GAristas], Null] == False], 
              If[
               Or[Length[$CellContext`GAristas] == Length[
                  OptionValue[$CellContext`pesos]], ToString[
                  OptionValue[$CellContext`pesos]] == ToString[{}]], 
               If[
                Or[ToString[$CellContext`GAristas] == ToString[{}], 
                 And[
                  MatrixQ[$CellContext`GAristas, IntegerQ], Part[
                    Dimensions[$CellContext`GAristas], 2] == 2, MemberQ[
                    ToCharacterCode[
                    ToString[$CellContext`GAristas]], 62760] == False]], 
                $CellContext`GrafoCO[$CellContext`GAristas]]]]]]]]; \
$CellContext`GrafoPonderadoQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          Not[
           MemberQ[{
             $CellContext`PesosAristas[$CellContext`GGrafo]}, Null]], True, 
          False], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           Not[
            MemberQ[{
              $CellContext`PesosAristas[$CellContext`GGrafo]}, Null]], True, 
           False]]]; 
      Options[$CellContext`MPGrafo] = {$CellContext`table -> 
         False}; $CellContext`MPGrafo[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         Pattern[$CellContext`GNodos, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GGrafoAuxiliar7, $CellContext`GVl13}, 
         If[
          VectorQ[$CellContext`GNodos], 
          If[MemberQ[$CellContext`GNodos, Null] == False, 
           If[$CellContext`GNodos != {}, 
            If[
             BooleanQ[
              OptionValue[$CellContext`table]], 
             If[MemberQ[{
                 $CellContext`PesosAristas[$CellContext`GGrafo]}, Null] == 
              False, 
              If[
               $CellContext`GrafoQ[$CellContext`GGrafo], 
               If[Sort[
                  VertexList[$CellContext`GGrafo]] == 
                Sort[$CellContext`GNodos], If[
                  $CellContext`AristasMixtasQ[$CellContext`GGrafo], \
$CellContext`GGrafoAuxiliar7 = Graph[$CellContext`GNodos, 
                    $CellContext`AristasCombinatoricaToWolframSystem[
                    $CellContext`AristasMixtasWolframSystemToCombinatorica[
                    EdgeList[$CellContext`GGrafo]], $CellContext`dirigido -> 
                    True]]; $CellContext`GVl13 = Select[
                    Flatten[
                    $CellContext`PesosAristas[$CellContext`GGrafo], 1], 
                    EdgeQ[$CellContext`GGrafoAuxiliar7, #] == 
                    False& ]; $CellContext`GGrafoAuxiliar7 = 
                   Graph[$CellContext`GNodos, 
                    EdgeList[$CellContext`GGrafoAuxiliar7], 
                    EdgeWeight -> $CellContext`GVl13], $CellContext`GVl13 = 
                   Select[
                    Flatten[
                    $CellContext`PesosAristas[$CellContext`GGrafo], 1], 
                    EdgeQ[$CellContext`GGrafo, #] == 
                    False& ]; $CellContext`GGrafoAuxiliar7 = 
                   Graph[$CellContext`GNodos, 
                    EdgeList[$CellContext`GGrafo], 
                    EdgeWeight -> $CellContext`GVl13]]; If[
                  Not[
                   OptionValue[$CellContext`table]], 
                  MatrixForm[
                   WeightedAdjacencyMatrix[$CellContext`GGrafoAuxiliar7]], 
                  TableForm[
                   Normal[
                    WeightedAdjacencyMatrix[$CellContext`GGrafoAuxiliar7]], 
                   TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar7]], 
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar7]]}, 
                   TableAlignments -> Center]]], 
               If[
                $CellContext`GrafoCQ[$CellContext`GGrafo], $CellContext`GVl13 = 
                 Select[
                   Flatten[
                    $CellContext`PesosAristas[$CellContext`GGrafo], 1], 
                   ListQ[#] == 
                   False& ]; $CellContext`GGrafoAuxiliar7 = \
$CellContext`CombinatoricaToGraph[$CellContext`GGrafo]; If[Sort[
                    VertexList[$CellContext`GGrafoAuxiliar7]] == 
                  Sort[$CellContext`GNodos], $CellContext`GGrafoAuxiliar7 = \
$CellContext`Grafo[
                    $CellContext`Edges[$CellContext`GGrafo], \
$CellContext`vertices -> $CellContext`GNodos, $CellContext`dirigido -> Not[
                    $CellContext`UndirectedQ[$CellContext`GGrafo]], \
$CellContext`pesos -> $CellContext`GVl13]; If[
                    Not[
                    OptionValue[$CellContext`table]], 
                    MatrixForm[
                    WeightedAdjacencyMatrix[$CellContext`GGrafoAuxiliar7]], 
                    TableForm[
                    Normal[
                    WeightedAdjacencyMatrix[$CellContext`GGrafoAuxiliar7]], 
                    TableHeadings -> {
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar7]], 
                    Map[Style[#, Black]& , 
                    VertexList[$CellContext`GGrafoAuxiliar7]]}, 
                    TableAlignments -> Center]]]]]]]]]]]; 
      Options[$CellContext`CombinatoricaToGraph] = {$CellContext`dimensions3d -> 
         False, $CellContext`mostrarpesos -> False, $CellContext`shape -> 
         False}; $CellContext`CombinatoricaToGraph[
         Pattern[$CellContext`GGrafo, 
          Blank[]], 
         OptionsPattern[]] := 
       Module[{$CellContext`GrafoO3d, $CellContext`GrafoONo3d}, \
$CellContext`GrafoO3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                True, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> True, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; $CellContext`GrafoONo3d[
            Pattern[$CellContext`GOGrafo, 
             Blank[]]] := Module[{$CellContext`GVl2}, 
            If[
             $CellContext`UndirectedQ[$CellContext`GOGrafo], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> False, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]], 
             If[
              ListQ[
               $CellContext`PesosAristas[$CellContext`GOGrafo]], \
$CellContext`GVl2 = Flatten[
                 $CellContext`PesosAristas[$CellContext`GOGrafo], 
                 1]; $CellContext`GVl2 = 
               Select[$CellContext`GVl2, VectorQ[#] == 
                 False& ]; $CellContext`Grafo[
                $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
                Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                   $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> 
                False, $CellContext`pesos -> $CellContext`GVl2, \
$CellContext`mostrarpesos -> 
                OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
                OptionValue[$CellContext`shape]], 
              $CellContext`Grafo[
               $CellContext`Edges[$CellContext`GOGrafo], \
$CellContext`dirigido -> True, $CellContext`vertices -> 
               Table[$CellContext`Gi4, {$CellContext`Gi4, 1, 
                  $CellContext`V[$CellContext`GOGrafo]}], \
$CellContext`dimensions3d -> False, $CellContext`mostrarpesos -> 
               OptionValue[$CellContext`mostrarpesos], $CellContext`shape -> 
               OptionValue[$CellContext`shape]]]]]; If[
           And[
            BooleanQ[
             OptionValue[$CellContext`dimensions3d]], 
            BooleanQ[
             OptionValue[$CellContext`mostrarpesos]], 
            BooleanQ[
             OptionValue[$CellContext`shape]]], 
           If[
            $CellContext`GrafoCQ[$CellContext`GGrafo], 
            If[
             OptionValue[$CellContext`dimensions3d], 
             $CellContext`GrafoO3d[$CellContext`GGrafo], 
             $CellContext`GrafoONo3d[$CellContext`GGrafo]]]]]; \
$CellContext`PesosAristas[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          WeightedGraphQ[$CellContext`GGrafo], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafo], If[Length[
               Quiet[
                Cases[
                 EdgeList[$CellContext`GGrafo], 
                 Pattern[$CellContext`Gicontador6, 
                   Blank[]] -> NumericQ[
                   
                   PropertyValue[{$CellContext`GGrafo, \
$CellContext`Gicontador6}, EdgeWeight]]]]] == 
             EdgeCount[$CellContext`GGrafo], $CellContext`GList3 = Table[{
                Part[
                 EdgeList[$CellContext`GGrafo], $CellContext`Gi2], 
                PropertyValue[{$CellContext`GGrafo, 
                  Part[
                   EdgeList[$CellContext`GGrafo], $CellContext`Gi2]}, 
                 EdgeWeight]}, {$CellContext`Gi2, 1, 
                EdgeCount[$CellContext`GGrafo]}]]; $CellContext`GList4 = 
            Select[$CellContext`GList3, DirectedEdge[
                Part[
                 Part[#, 1], 1], 
                Part[
                 Part[#, 1], 2]] == Part[#, 1]& ]; $CellContext`GList5 = 
            ReplaceAll[
              Select[$CellContext`GList3, UndirectedEdge[
                 Part[
                  Part[#, 1], 1], 
                 Part[
                  Part[#, 1], 2]] == Part[#, 1]& ], UndirectedEdge -> 
              DirectedEdge]; Join[$CellContext`GList4, $CellContext`GList5, 
             Reverse[$CellContext`GList5, 3]], 
           If[Length[
              Quiet[
               Cases[
                EdgeList[$CellContext`GGrafo], 
                Pattern[$CellContext`Gicontador6, 
                  Blank[]] -> NumericQ[
                  
                  PropertyValue[{$CellContext`GGrafo, \
$CellContext`Gicontador6}, EdgeWeight]]]]] == EdgeCount[$CellContext`GGrafo], 
            Table[{
              Part[
               EdgeList[$CellContext`GGrafo], $CellContext`Gi2], 
              PropertyValue[{$CellContext`GGrafo, 
                Part[
                 EdgeList[$CellContext`GGrafo], $CellContext`Gi2]}, 
               EdgeWeight]}, {$CellContext`Gi2, 1, 
              EdgeCount[$CellContext`GGrafo]}]]]], 
         If[
          $CellContext`GrafoCQ[$CellContext`GGrafo], 
          If[
           ListQ[
            $CellContext`Edges[$CellContext`GGrafo, EdgeWeight]], 
           $CellContext`Edges[$CellContext`GGrafo, 
            EdgeWeight]]]]; $CellContext`MBooleanQ[
         Pattern[$CellContext`MatrizSBooleana, 
          Blank[]]] := If[
         MatrixQ[$CellContext`MatrizSBooleana, NumericQ], 
         If[MemberQ[
            Flatten[$CellContext`MatrizSBooleana], Null] == False, 
          If[$CellContext`MatrizSBooleana^2 == $CellContext`MatrizSBooleana, 
           True, False], False], False]; $CellContext`AristasMixtasQ[
         Pattern[$CellContext`GGrafo, 
          Blank[]]] := If[
         $CellContext`GrafoQ[$CellContext`GGrafo], 
         If[
          And[Select[
             EdgeList[$CellContext`GGrafo], DirectedEdge[
               Part[#, 1], 
               Part[#, 2]] == #& ] != {}, Select[
             EdgeList[$CellContext`GGrafo], UndirectedEdge[
               Part[#, 1], 
               Part[#, 2]] == #& ] != {}], True, 
          False]]; $CellContext`AristasMixtasWolframSystemToCombinatorica[
         Pattern[$CellContext`GAristasGrafo, 
          Blank[]]] := 
       Module[{$CellContext`GGrafoAuxiliar10 = 
          Graph[$CellContext`GAristasGrafo]}, 
         If[
          GraphQ[$CellContext`GGrafoAuxiliar10], 
          If[
           $CellContext`AristasMixtasQ[$CellContext`GGrafoAuxiliar10], 
           Join[
            $CellContext`AristasWolframSystemToCombinatorica[
             Select[
              EdgeList[$CellContext`GGrafoAuxiliar10], DirectedEdge[
                Part[#, 1], 
                Part[#, 2]] == #& ]], 
            $CellContext`AristasWolframSystemToCombinatorica[
             Select[
              EdgeList[$CellContext`GGrafoAuxiliar10], UndirectedEdge[
                Part[#, 1], 
                Part[#, 2]] == #& ]], 
            Reverse[
             $CellContext`AristasWolframSystemToCombinatorica[
              Select[
               EdgeList[$CellContext`GGrafoAuxiliar10], UndirectedEdge[
                 Part[#, 1], 
                 Part[#, 2]] == #& ]], 2]]]]]); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.6786167041663084`*^9, 3.6786177338686337`*^9, 3.678617801486747*^9, 
   3.6786181265929155`*^9, 3.678618447942705*^9, 3.6786187021862507`*^9, {
   3.8011548787750573`*^9, 3.801154901734952*^9}, 3.801154938266068*^9, 
   3.801154968355096*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"3b873ab7-9642-471e-81fc-1d7e797e27b7"]
}, Open  ]]
},
WindowSize->{1366, 685},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"176b8f39-aedc-4bd6-8643-c69848645a12"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 205442, 4332, 31941, "Input",ExpressionUUID->"1f549835-aef4-478e-b7ca-5124783becaa"],
Cell[206025, 4356, 101801, 2061, 726, "Output",ExpressionUUID->"3b873ab7-9642-471e-81fc-1d7e797e27b7"]
}, Open  ]]
}
]
*)

